/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.tekton.decorator.TaskProvidingDecorator;
import io.dekorate.tekton.decorator.TektonStepDecorator;
import io.dekorate.utils.Metadata;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.tekton.pipeline.v1beta1.TaskSpecFluent;
import java.util.Optional;

public abstract class NamedTaskDecorator
extends Decorator<VisitableBuilder> {
    protected static final String ANY = null;
    private final String taskName;
    private final TaskVisitor taskVisitor = new TaskVisitor();

    public NamedTaskDecorator(String taskName) {
        this.taskName = taskName;
    }

    public void visit(VisitableBuilder builder) {
        Optional objectMeta = Metadata.getMetadata((Builder)builder);
        if (!objectMeta.isPresent()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.taskName) || objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.taskName)).isPresent()) {
            builder.accept(new Visitor[]{this.taskVisitor});
        }
    }

    public abstract void andThenVisit(TaskSpecFluent<?> var1);

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, TaskProvidingDecorator.class};
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{TektonStepDecorator.class};
    }

    private class TaskVisitor
    extends TypedVisitor<TaskSpecFluent<?>> {
        private TaskVisitor() {
        }

        public void visit(TaskSpecFluent<?> taskSpec) {
            NamedTaskDecorator.this.andThenVisit(taskSpec);
        }
    }
}

