/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.utils.Strings;

public interface StepDecorator {
    public static final char SLASH = '/';
    public static final String SOURCE = "source";
    public static final String WORKSPACE_PATH = "$(workspaces.%s.path)";
    public static final String PARAMS_FORMAT = "$(params.%s)";
    public static final String RESOURCES_INPUTS_FORMAT = "$(resources.inputs.%s.path)";
    public static final String PATH_TO_FILE_FORMAT = "$(resources.inputs.source.path)/%s/$(inputs.params.pathToContext)/%s";

    default public String param(String name) {
        return String.format(PARAMS_FORMAT, name);
    }

    default public String resourceInputPath(String name) {
        return String.format(RESOURCES_INPUTS_FORMAT, name);
    }

    default public String sourcePath(String ... path) {
        return this.workspacePath(SOURCE, path);
    }

    default public String workspacePath(String workspace, String ... path) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(WORKSPACE_PATH, workspace));
        if (path != null && path.length > 0) {
            sb.append('/');
            sb.append(Strings.join((Object[])path, (char)'/'));
        }
        return sb.toString();
    }
}

