/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Generics;
import io.dekorate.utils.Metadata;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.tekton.pipeline.v1beta1.StepBuilder;
import io.fabric8.tekton.pipeline.v1beta1.StepFluent;
import java.util.Optional;

public abstract class TektonStepDecorator<T>
extends Decorator<VisitableBuilder> {
    public static final String ANY = null;
    private final String taskName;
    private final String stepName;
    private final TaskVisitor deploymentVisitor = new TaskVisitor();
    private final StepVisitor stepVisitor = new StepVisitor();

    public TektonStepDecorator() {
        this(null, null);
    }

    public TektonStepDecorator(String stepName) {
        this(null, stepName);
    }

    public TektonStepDecorator(String taskName, String stepName) {
        this.taskName = taskName;
        this.stepName = stepName;
    }

    public void visit(VisitableBuilder builder) {
        Optional objectMeta = Metadata.getMetadata((Builder)builder);
        if (!objectMeta.isPresent()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.taskName) || objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.taskName)).isPresent()) {
            builder.accept(new Visitor[]{this.deploymentVisitor});
        }
    }

    protected boolean isApplicable(StepFluent<?> step) {
        return Strings.isNullOrEmpty((String)this.stepName) || this.stepName.equals(step.getName());
    }

    public abstract void andThenVisit(T var1);

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }

    private class StepVisitor
    extends TypedVisitor<T> {
        private StepVisitor() {
        }

        public void visit(T item) {
            TektonStepDecorator.this.andThenVisit(item);
        }

        public Class<T> getType() {
            return (Class)Generics.getTypeArguments(TektonStepDecorator.class, ((Object)((Object)TektonStepDecorator.this)).getClass()).get(0);
        }
    }

    private class TaskVisitor
    extends TypedVisitor<StepBuilder> {
        private TaskVisitor() {
        }

        public void visit(StepBuilder step) {
            if (!TektonStepDecorator.this.isApplicable((StepFluent<?>)step)) {
                return;
            }
            step.accept(new Visitor[]{TektonStepDecorator.this.stepVisitor});
        }
    }
}

