/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.manifest;

import io.dekorate.BuildImage;
import io.dekorate.BuildServiceFactories;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.DekorateException;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ManifestGenerator;
import io.dekorate.ResourceRegistry;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddDockerConfigJsonSecretDecorator;
import io.dekorate.kubernetes.decorator.AddRoleBindingResourceDecorator;
import io.dekorate.kubernetes.decorator.AddSecretToServiceAccountDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.Project;
import io.dekorate.project.ScmInfo;
import io.dekorate.tekton.annotation.TektonImageBuildStrategy;
import io.dekorate.tekton.config.EditableTektonConfig;
import io.dekorate.tekton.config.TektonConfig;
import io.dekorate.tekton.config.TektonConfigBuilder;
import io.dekorate.tekton.decorator.AddArrayParamToTaskDecorator;
import io.dekorate.tekton.decorator.AddDeployStepDecorator;
import io.dekorate.tekton.decorator.AddDockerSocketMountDecorator;
import io.dekorate.tekton.decorator.AddDockerSocketVolumeDecorator;
import io.dekorate.tekton.decorator.AddImageBuildStepDecorator;
import io.dekorate.tekton.decorator.AddImagePushStepDecorator;
import io.dekorate.tekton.decorator.AddProjectBuildStepDecorator;
import io.dekorate.tekton.decorator.AddPvcToPipelineRunDecorator;
import io.dekorate.tekton.decorator.AddPvcToTaskRunDecorator;
import io.dekorate.tekton.decorator.AddResourceInputToTaskDecorator;
import io.dekorate.tekton.decorator.AddResourceOutputToTaskDecorator;
import io.dekorate.tekton.decorator.AddResourceToPipelineDecorator;
import io.dekorate.tekton.decorator.AddServiceAccountToTaskDecorator;
import io.dekorate.tekton.decorator.AddStringParamToTaskDecorator;
import io.dekorate.tekton.decorator.AddToArgsDecorator;
import io.dekorate.tekton.decorator.AddWorkspaceToPipelineDecorator;
import io.dekorate.tekton.decorator.AddWorkspaceToPipelineTaskDecorator;
import io.dekorate.tekton.decorator.AddWorkspaceToTaskDecorator;
import io.dekorate.tekton.step.ImageBuildStep;
import io.dekorate.tekton.util.TektonUtils;
import io.dekorate.utils.Images;
import io.dekorate.utils.Jvm;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleFluent;
import io.fabric8.tekton.pipeline.v1beta1.Pipeline;
import io.fabric8.tekton.pipeline.v1beta1.PipelineBuilder;
import io.fabric8.tekton.pipeline.v1beta1.PipelineFluent;
import io.fabric8.tekton.pipeline.v1beta1.PipelineResourceBindingFluent;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRun;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRunBuilder;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRunFluent;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRunSpecFluent;
import io.fabric8.tekton.pipeline.v1beta1.PipelineSpecFluent;
import io.fabric8.tekton.pipeline.v1beta1.PipelineTask;
import io.fabric8.tekton.pipeline.v1beta1.PipelineTaskBuilder;
import io.fabric8.tekton.pipeline.v1beta1.PipelineTaskFluent;
import io.fabric8.tekton.pipeline.v1beta1.PipelineTaskResourcesFluent;
import io.fabric8.tekton.pipeline.v1beta1.Task;
import io.fabric8.tekton.pipeline.v1beta1.TaskBuilder;
import io.fabric8.tekton.pipeline.v1beta1.TaskFluent;
import io.fabric8.tekton.pipeline.v1beta1.TaskResourceBindingFluent;
import io.fabric8.tekton.pipeline.v1beta1.TaskRun;
import io.fabric8.tekton.pipeline.v1beta1.TaskRunBuilder;
import io.fabric8.tekton.pipeline.v1beta1.TaskRunFluent;
import io.fabric8.tekton.pipeline.v1beta1.TaskRunResourcesFluent;
import io.fabric8.tekton.pipeline.v1beta1.TaskRunSpecFluent;
import io.fabric8.tekton.resource.v1alpha1.PipelineResource;
import io.fabric8.tekton.resource.v1alpha1.PipelineResourceBuilder;
import io.fabric8.tekton.resource.v1alpha1.PipelineResourceFluent;
import io.fabric8.tekton.resource.v1alpha1.PipelineResourceSpecFluent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TektonManifestGenerator
implements ManifestGenerator<TektonConfig>,
WithProject {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private static final String TEKTON_PIPELINE = "tekton-pipeline";
    private static final String TEKTON_PIPELINE_RUN = "tekton-pipeline-run";
    private static final String TEKTON_TASK = "tekton-task";
    private static final String TEKTON_TASK_RUN = "tekton-task-run";
    private static final String AND = "and";
    private static final String GIT = "git";
    private static final String REVISION = "revision";
    private static final String URL = "url";
    private static final String IMAGE = "image";
    private static final String BUILD = "build";
    private static final String PUSH = "push";
    private static final String DEPLOY = "deploy";
    private static final String WORKSPACE = "workspace";
    private static final String RUN = "run";
    private static final String NOW = "now";
    private static final String GIT_SOURCE = "git-source";
    private static final String OUTPUT_IMAGE = "out-image";
    private static final String PIPELINE_SOURCE_WS = "pipeline-source-ws";
    private static final String PIPELINE_SOURCE_WS_DECSCRIPTION = "The workspace to share between pipeline steps";
    private static final String PIPELINE_M2_WS = "pipeline-m2-ws";
    private static final String PIPELINE_M2_WS_DECSCRIPTION = "The workspace to store m2 artifacts";
    private static final String PROJECT = "project";
    private static final String DASH = "-";
    private static final String MAVEN_LOCAL_REPO_SYS_PROPERTY = "-Dmaven.repo.local=%s";
    private static final String IMAGE_PULL_SECRETS_SYS_PROPERTY = "-Ddekorate.%s.image-pull-secrets=";
    private static final String USER_NAME_SYS_PROP = "-Duser.name=";
    private static final String TEKTON = "tekton";
    private static final String DEFAULT_TIMEOUT = "1h0m0s";
    private final ResourceRegistry resourceRegistry;
    private final ConfigurationRegistry configurationRegistry;

    public TektonManifestGenerator(ResourceRegistry resources, ConfigurationRegistry configurationRegistry) {
        this.resourceRegistry = resources;
        this.configurationRegistry = configurationRegistry;
    }

    public int order() {
        return 500;
    }

    public String getKey() {
        return TEKTON;
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(TektonConfig.class) || type.equals(EditableTektonConfig.class);
    }

    public void generate(TektonConfig config) {
        ImageConfiguration imageConfiguration = TektonManifestGenerator.getImageConfiguration(this.getProject(), config, this.configurationRegistry);
        this.generateCommon(TEKTON_PIPELINE, config, imageConfiguration);
        this.generatePipelineResources(config);
        this.generateCommon(TEKTON_TASK, config, imageConfiguration);
        this.generateTaskResources(config);
    }

    public void generateCommon(String group, TektonConfig config, final ImageConfiguration imageConfiguration) {
        if (Strings.isNotNullOrEmpty((String)config.getExternalGitPipelineResource())) {
            LOGGER.info("Tekton " + group.split(DASH)[1] + " expects existing git pipeline resource named: " + config.getExternalGitPipelineResource() + "!");
        } else if (config.getProject().getScmInfo() != null) {
            this.resourceRegistry.add(group, (HasMetadata)this.createGitResource(config));
        } else {
            throw new IllegalStateException("Project is not under version control, or unsupported version control system. Aborting generation of tekton resources!");
        }
        this.resourceRegistry.add(group, (HasMetadata)this.createOutputImageResource(config, imageConfiguration));
        this.resourceRegistry.add(group, (HasMetadata)this.createRole(config));
        this.resourceRegistry.decorate(group, (Decorator)new AddWorkspaceToTaskDecorator(null, config.getSourceWorkspace(), "The workspace to hold all project sources", false, null));
        this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(null, "pathToContext", "Path to context. Usually refers to module directory", TektonUtils.getContextPath(this.getProject())));
        String monolithTaskName = TektonManifestGenerator.monolithTaskName(config);
        String projectBuildTaskName = TektonManifestGenerator.projectBuildTaskName(config);
        String projectBuildStepName = TektonManifestGenerator.projectBuildStepName(config);
        String imageBuildTaskName = TektonManifestGenerator.imageBuildTaskName(config);
        String imagePushTaskName = TektonManifestGenerator.imagePushTaskName(config);
        String deployTaskName = TektonManifestGenerator.deployTaskName(config);
        if (group.equals(TEKTON_TASK)) {
            projectBuildTaskName = monolithTaskName;
            imageBuildTaskName = monolithTaskName;
            imagePushTaskName = monolithTaskName;
            deployTaskName = monolithTaskName;
        }
        BuildInfo build = config.getProject().getBuildInfo();
        BuildImage projectBuildImage = Strings.isNotNullOrEmpty((String)config.getProjectBuilderImage()) && Strings.isNotNullOrEmpty((String)config.getProjectBuilderCommand()) ? new BuildImage(config.getProjectBuilderImage(), config.getProjectBuilderCommand(), config.getProjectBuilderArguments()) : (BuildImage)BuildImage.find((String)build.getBuildTool(), (String)build.getBuildToolVersion(), (int)Jvm.getVersion(), null).orElseThrow(() -> new IllegalStateException("No project builder image was found!"));
        this.resourceRegistry.decorate(group, (Decorator)new AddResourceInputToTaskDecorator(projectBuildTaskName, GIT, GIT_SOURCE, "/source/" + config.getName()));
        this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(projectBuildTaskName, "projectBuilderImage", "The image to use for performing project build", projectBuildImage.getImage()));
        this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(projectBuildTaskName, "projectBuilderCommand", "The command to use for performing project build", projectBuildImage.getCommand()));
        this.resourceRegistry.decorate(group, (Decorator)new AddArrayParamToTaskDecorator(projectBuildTaskName, "projectBuilderArgs", "The command arguments to use for performing project build", projectBuildImage.getArguments()));
        this.resourceRegistry.decorate(group, (Decorator)new AddToArgsDecorator(projectBuildTaskName, projectBuildStepName, USER_NAME_SYS_PROP + imageConfiguration.getGroup()));
        this.resourceRegistry.decorate(group, (Decorator)new AddProjectBuildStepDecorator(projectBuildTaskName, "project-build", config.getName()));
        TektonImageBuildStrategy imageBuildStrategy = config.getImageBuildStrategy() != null ? config.getImageBuildStrategy() : TektonImageBuildStrategy.kaniko;
        Object imageBuildStep = ((ImageBuildStep)((ImageBuildStep)((ImageBuildStep)((ImageBuildStep)((ImageBuildStep)((ImageBuildStep)((ImageBuildStep)imageBuildStrategy.getStep().withContext(TektonUtils.getContextPath(this.getProject()))).withDockerfile(config.getDockerfile())).withBuildImage(config.getImageBuildImage())).withBuildCommand(config.getImageBuildCommand())).withBuildArguments(config.getImageBuildArguments())).withPushImage(config.getImagePushImage())).withPushCommand(config.getImagePushCommand())).withPushArguments(config.getImagePushArguments());
        String imageBuildImage = ((ImageBuildStep)imageBuildStep).getBuildImage();
        String imageBuildCommand = ((ImageBuildStep)imageBuildStep).getBuildCommand();
        String[] imageBuildArgs = ((ImageBuildStep)imageBuildStep).getBuildArguments();
        this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(imageBuildTaskName, "imageBuilderImage", "The image to use for performing project build", imageBuildImage));
        this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(imageBuildTaskName, "imageBuilderCommand", "The command to use for performing project build", imageBuildCommand));
        this.resourceRegistry.decorate(group, (Decorator)new AddArrayParamToTaskDecorator(imageBuildTaskName, "imageBuilderArgs", "The command arguments to use for performing project build", imageBuildArgs));
        this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(imageBuildTaskName, "pathToDockerfile", "Path to Dockerfile", config.getDockerfile()));
        this.resourceRegistry.decorate(group, (Decorator)new AddImageBuildStepDecorator(imageBuildTaskName, config.getName()));
        this.resourceRegistry.decorate(group, (Decorator)new AddResourceOutputToTaskDecorator(imageBuildTaskName, IMAGE, IMAGE));
        if (((ImageBuildStep)imageBuildStep).isDockerSocketRequired()) {
            this.resourceRegistry.decorate(group, (Decorator)new AddDockerSocketMountDecorator(imageBuildTaskName, "image-build"));
            this.resourceRegistry.decorate(group, (Decorator)new AddDockerSocketVolumeDecorator(imageBuildTaskName));
        }
        if (((ImageBuildStep)imageBuildStep).isPushRequired()) {
            String imagePushImage = ((ImageBuildStep)imageBuildStep).getPushImage();
            String imagePushCommand = ((ImageBuildStep)imageBuildStep).getPushCommand();
            String[] imagePushArgs = ((ImageBuildStep)imageBuildStep).getPushArguments();
            this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(imagePushTaskName, "imagePushImage", "The image to use for performing project push", imagePushImage));
            this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(imagePushTaskName, "imagePushCommand", "The command to use for performing project push", imagePushCommand));
            this.resourceRegistry.decorate(group, (Decorator)new AddArrayParamToTaskDecorator(imagePushTaskName, "imagePushArgs", "The command arguments to use for performing project push", imagePushArgs));
            this.resourceRegistry.decorate(group, (Decorator)new AddImagePushStepDecorator(imagePushTaskName, config.getName()));
            if (((ImageBuildStep)imageBuildStep).isDockerSocketRequired()) {
                this.resourceRegistry.decorate(group, (Decorator)new AddDockerSocketMountDecorator(imagePushTaskName, "image-push"));
                this.resourceRegistry.decorate(group, (Decorator)new AddDockerSocketVolumeDecorator(imagePushTaskName));
            }
        }
        this.resourceRegistry.decorate(group, (Decorator)new AddStringParamToTaskDecorator(deployTaskName, "pathToYml", "Path to yml", "target/classes/META-INF/dekorate/kubernetes.yml"));
        this.resourceRegistry.decorate(group, (Decorator)new AddDeployStepDecorator(deployTaskName, config.getName(), config.getDeployerImage()));
        HashMap<String, String> annotations = new HashMap<String, String>(){
            {
                this.put("tekton.dev/docker-0", "https://" + imageConfiguration.getRegistry());
            }
        };
        String m2WorkspaceClaimName = TektonManifestGenerator.m2WorkspaceClaimName(config);
        if (Strings.isNotNullOrEmpty((String)m2WorkspaceClaimName)) {
            String m2Path = "/workspaces/" + config.getM2Workspace();
            this.resourceRegistry.add(group, (HasMetadata)this.createM2WorkspacePvc(config));
            this.resourceRegistry.decorate(group, (Decorator)new AddWorkspaceToTaskDecorator(projectBuildTaskName, config.getM2Workspace(), "Local maven repository workspace", false, m2Path));
            this.resourceRegistry.decorate(group, (Decorator)new AddToArgsDecorator(projectBuildTaskName, projectBuildStepName, String.format(MAVEN_LOCAL_REPO_SYS_PROPERTY, m2Path)));
        }
        if (Strings.isNotNullOrEmpty((String)config.getImagePushServiceAccount())) {
            this.resourceRegistry.decorate(group + DASH + RUN, (Decorator)new AddServiceAccountToTaskDecorator("image-build", config.getImagePushServiceAccount()));
        } else {
            String generatedServiceAccount = config.getName();
            this.resourceRegistry.decorate(group + DASH + RUN, (Decorator)new AddServiceAccountToTaskDecorator("image-build", generatedServiceAccount));
            if (Strings.isNotNullOrEmpty((String)config.getImagePushSecret())) {
                this.resourceRegistry.decorate(group, (Decorator)new AddSecretToServiceAccountDecorator(generatedServiceAccount, config.getImagePushSecret()));
                this.resourceRegistry.decorate(group, (Decorator)new AddToArgsDecorator(projectBuildTaskName, projectBuildStepName, String.format(IMAGE_PULL_SECRETS_SYS_PROPERTY, group) + config.getImagePushSecret()));
            } else if (config.isUseLocalDockerConfigJson()) {
                String generatedSecret = config.getName() + "-registry-credentials";
                Path dockerConfigJson = Paths.get(System.getProperty("user.home"), ".docker", "config.json");
                if (!dockerConfigJson.toFile().exists()) {
                    throw new IllegalStateException("User requested to use the local `.docker/config.json` file, but it doesn't exist!");
                }
                LOGGER.warning(dockerConfigJson.toAbsolutePath().normalize().toString() + " is going to be added as part of Secret: " + generatedSecret);
                this.resourceRegistry.decorate(group, (Decorator)new AddToArgsDecorator(projectBuildTaskName, projectBuildStepName, String.format(IMAGE_PULL_SECRETS_SYS_PROPERTY, group) + generatedSecret));
                this.resourceRegistry.decorate(group, (Decorator)new AddDockerConfigJsonSecretDecorator(generatedSecret, dockerConfigJson, (Map)annotations));
                this.resourceRegistry.decorate(group, (Decorator)new AddSecretToServiceAccountDecorator(generatedServiceAccount, generatedSecret));
            } else if (Strings.isNotNullOrEmpty((String)config.getRegistryUsername()) && Strings.isNotNullOrEmpty((String)config.getRegistryPassword())) {
                String generatedSecret = config.getName() + "-registry-credentials";
                this.resourceRegistry.decorate(group, (Decorator)new AddToArgsDecorator(projectBuildTaskName, projectBuildStepName, String.format(IMAGE_PULL_SECRETS_SYS_PROPERTY, group) + generatedSecret));
                this.resourceRegistry.decorate(group, (Decorator)new AddDockerConfigJsonSecretDecorator(generatedSecret, config.getRegistry(), config.getRegistryUsername(), config.getRegistryPassword(), (Map)annotations));
                this.resourceRegistry.decorate(group, (Decorator)new AddSecretToServiceAccountDecorator(generatedServiceAccount, generatedSecret));
            } else {
                LOGGER.error("An existing builder image service account or secret is required! Alternatively, you can specify a registry username and password!");
            }
        }
    }

    public void generatePipelineResources(TektonConfig config) {
        String projectBuildTaskName = TektonManifestGenerator.projectBuildTaskName(config);
        String imageBuildTaskName = TektonManifestGenerator.imageBuildTaskName(config);
        String deployTaskName = TektonManifestGenerator.deployTaskName(config);
        String m2WorkspaceClaimName = TektonManifestGenerator.m2WorkspaceClaimName(config);
        this.resourceRegistry.add(TEKTON_PIPELINE, (HasMetadata)this.createTask(projectBuildTaskName));
        this.resourceRegistry.add(TEKTON_PIPELINE, (HasMetadata)this.createTask(imageBuildTaskName));
        this.resourceRegistry.add(TEKTON_PIPELINE, (HasMetadata)this.createTask(deployTaskName));
        String pipelineName = config.getName();
        this.resourceRegistry.add(TEKTON_PIPELINE, (HasMetadata)this.createPipeline(config));
        this.resourceRegistry.decorate(TEKTON_PIPELINE, (Decorator)new AddResourceToPipelineDecorator(pipelineName, GIT, GIT_SOURCE, false));
        this.resourceRegistry.decorate(TEKTON_PIPELINE, (Decorator)new AddResourceToPipelineDecorator(pipelineName, IMAGE, OUTPUT_IMAGE, false));
        if (Strings.isNullOrEmpty((String)config.getExternalSourceWorkspaceClaim())) {
            this.resourceRegistry.add(TEKTON_PIPELINE, (HasMetadata)this.createSourceWorkspacePvc(config));
        }
        this.resourceRegistry.add(TEKTON_PIPELINE_RUN, (HasMetadata)this.createPipelineRun(config));
        if (Strings.isNotNullOrEmpty((String)m2WorkspaceClaimName)) {
            this.resourceRegistry.decorate(TEKTON_PIPELINE, (Decorator)new AddWorkspaceToPipelineTaskDecorator(null, "project-build", config.getM2Workspace(), PIPELINE_M2_WS));
            this.resourceRegistry.decorate(TEKTON_PIPELINE, (Decorator)new AddWorkspaceToPipelineDecorator(null, PIPELINE_M2_WS, "Local maven repository workspace"));
            this.resourceRegistry.decorate(TEKTON_PIPELINE_RUN, (Decorator)new AddPvcToPipelineRunDecorator(null, PIPELINE_M2_WS, m2WorkspaceClaimName, false));
        }
        this.resourceRegistry.decorate(TEKTON_PIPELINE, (Decorator)new AddServiceAccountResourceDecorator(imageBuildTaskName));
        this.resourceRegistry.decorate(TEKTON_PIPELINE, (Decorator)new AddRoleBindingResourceDecorator(imageBuildTaskName + ":deployer", config.getName(), "pipeline-deployer", AddRoleBindingResourceDecorator.RoleKind.Role));
    }

    public void generateTaskResources(TektonConfig config) {
        String monolithTaskName = TektonManifestGenerator.monolithTaskName(config);
        String m2WorkspaceClaimName = TektonManifestGenerator.m2WorkspaceClaimName(config);
        this.resourceRegistry.add(TEKTON_TASK, (HasMetadata)this.createTask(monolithTaskName));
        this.resourceRegistry.add(TEKTON_TASK_RUN, (HasMetadata)this.createTaskRun(config));
        if (Strings.isNotNullOrEmpty((String)m2WorkspaceClaimName)) {
            this.resourceRegistry.decorate(TEKTON_TASK_RUN, (Decorator)new AddPvcToTaskRunDecorator(null, config.getM2Workspace(), m2WorkspaceClaimName, false));
        }
        this.resourceRegistry.decorate(TEKTON_TASK, (Decorator)new AddServiceAccountResourceDecorator(monolithTaskName));
        this.resourceRegistry.decorate(TEKTON_TASK, (Decorator)new AddRoleBindingResourceDecorator(monolithTaskName + ":deployer", config.getName(), "pipeline-deployer", AddRoleBindingResourceDecorator.RoleKind.Role));
    }

    public PipelineResource createGitResource(TektonConfig config) {
        ScmInfo scm = Optional.ofNullable(config.getProject().getScmInfo()).orElseThrow(() -> new IllegalStateException("No scm info found!"));
        return ((PipelineResourceBuilder)((PipelineResourceFluent.SpecNested)((PipelineResourceSpecFluent.ParamsNested)((PipelineResourceSpecFluent.ParamsNested)((PipelineResourceFluent.SpecNested)((PipelineResourceSpecFluent.ParamsNested)((PipelineResourceSpecFluent.ParamsNested)((PipelineResourceFluent.SpecNested)((PipelineResourceBuilder)((PipelineResourceFluent.MetadataNested)new PipelineResourceBuilder().withNewMetadata().withName(TektonManifestGenerator.gitResourceName(config))).endMetadata()).withNewSpec().withType(GIT)).addNewParam().withName(URL)).withValue((String)scm.getRemote().get("origin"))).endParam()).addNewParam().withName(REVISION)).withValue(scm.getCommit())).endParam()).endSpec()).build();
    }

    public PipelineResource createOutputImageResource(TektonConfig config, ImageConfiguration imageConfig) {
        String image = Images.getImage((String)(Strings.isNotNullOrEmpty((String)imageConfig.getRegistry()) ? imageConfig.getRegistry() : "docker.io"), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((PipelineResourceBuilder)((PipelineResourceFluent.SpecNested)((PipelineResourceSpecFluent.ParamsNested)((PipelineResourceSpecFluent.ParamsNested)((PipelineResourceFluent.SpecNested)((PipelineResourceBuilder)((PipelineResourceFluent.MetadataNested)new PipelineResourceBuilder().withNewMetadata().withName(TektonManifestGenerator.outputImageResourceName(config))).endMetadata()).withNewSpec().withType(IMAGE)).addNewParam().withName(URL)).withValue(image)).endParam()).endSpec()).build();
    }

    public Task createTask(String name) {
        return ((TaskBuilder)((TaskBuilder)((TaskFluent.MetadataNested)new TaskBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().endSpec()).build();
    }

    public PipelineTask createProjectBuildPipelineTask(TektonConfig config) {
        return ((PipelineTaskBuilder)((PipelineTaskFluent.ParamsNested)((PipelineTaskFluent.ParamsNested)((PipelineTaskBuilder)((PipelineTaskFluent.ResourcesNested)((PipelineTaskResourcesFluent.InputsNested)((PipelineTaskResourcesFluent.InputsNested)((PipelineTaskBuilder)((PipelineTaskFluent.WorkspacesNested)((PipelineTaskFluent.WorkspacesNested)((PipelineTaskBuilder)((PipelineTaskFluent.TaskRefNested)((PipelineTaskBuilder)new PipelineTaskBuilder().withName("project-build")).withNewTaskRef().withName(TektonManifestGenerator.projectBuildTaskName(config))).endTaskRef()).addNewWorkspace().withName(config.getSourceWorkspace())).withWorkspace(PIPELINE_SOURCE_WS)).endWorkspace()).withNewResources().addNewInput().withName(GIT_SOURCE)).withResource(GIT_SOURCE)).endInput()).endResources()).addNewParam().withName("pathToContext")).withNewValue(TektonUtils.getContextPath(this.getProject()))).endParam()).build();
    }

    public PipelineTask createImageBuildPipelineTask(TektonConfig config) {
        return ((PipelineTaskBuilder)((PipelineTaskBuilder)((PipelineTaskFluent.ParamsNested)((PipelineTaskFluent.ParamsNested)((PipelineTaskBuilder)((PipelineTaskFluent.WorkspacesNested)((PipelineTaskFluent.WorkspacesNested)((PipelineTaskBuilder)((PipelineTaskFluent.ResourcesNested)((PipelineTaskResourcesFluent.OutputsNested)((PipelineTaskResourcesFluent.OutputsNested)((PipelineTaskBuilder)((PipelineTaskFluent.TaskRefNested)((PipelineTaskBuilder)new PipelineTaskBuilder().withName("image-build")).withNewTaskRef().withName(TektonManifestGenerator.imageBuildTaskName(config))).endTaskRef()).withNewResources().addNewOutput().withName(IMAGE)).withResource(OUTPUT_IMAGE)).endOutput()).endResources()).addNewWorkspace().withName(config.getSourceWorkspace())).withWorkspace(PIPELINE_SOURCE_WS)).endWorkspace()).addNewParam().withName("pathToContext")).withNewValue(TektonUtils.getContextPath(this.getProject()))).endParam()).withRunAfter(new String[]{"project-build"})).build();
    }

    public PipelineTask createDeployPipelineTask(TektonConfig config) {
        return ((PipelineTaskBuilder)((PipelineTaskBuilder)((PipelineTaskFluent.ParamsNested)((PipelineTaskFluent.ParamsNested)((PipelineTaskBuilder)((PipelineTaskFluent.ParamsNested)((PipelineTaskFluent.ParamsNested)((PipelineTaskBuilder)((PipelineTaskFluent.WorkspacesNested)((PipelineTaskFluent.WorkspacesNested)((PipelineTaskBuilder)((PipelineTaskFluent.TaskRefNested)((PipelineTaskBuilder)new PipelineTaskBuilder().withName(DEPLOY)).withNewTaskRef().withName(TektonManifestGenerator.deployTaskName(config))).endTaskRef()).addNewWorkspace().withName(config.getSourceWorkspace())).withWorkspace(PIPELINE_SOURCE_WS)).endWorkspace()).addNewParam().withName("pathToYml")).withNewValue(TektonManifestGenerator.getYamlPath(this.getProject()))).endParam()).addNewParam().withName("pathToContext")).withNewValue(TektonUtils.getContextPath(this.getProject()))).endParam()).withRunAfter(new String[]{"project-build", "image-build"})).build();
    }

    public Pipeline createPipeline(TektonConfig config) {
        return ((PipelineBuilder)((PipelineFluent.SpecNested)((PipelineFluent.SpecNested)((PipelineSpecFluent.ResourcesNested)((PipelineSpecFluent.ResourcesNested)((PipelineFluent.SpecNested)((PipelineSpecFluent.ResourcesNested)((PipelineSpecFluent.ResourcesNested)((PipelineFluent.SpecNested)((PipelineSpecFluent.WorkspacesNested)((PipelineBuilder)((PipelineFluent.MetadataNested)new PipelineBuilder().withNewMetadata().withName(config.getName())).endMetadata()).withNewSpec().addNewWorkspace().withName(PIPELINE_SOURCE_WS)).endWorkspace()).addNewResource().withType(GIT)).withName(GIT_SOURCE)).endResource()).addNewResource().withType(IMAGE)).withName(OUTPUT_IMAGE)).endResource()).addToTasks(new PipelineTask[]{this.createProjectBuildPipelineTask(config), this.createImageBuildPipelineTask(config), this.createDeployPipelineTask(config)})).endSpec()).build();
    }

    public Role createRole(TektonConfig config) {
        return ((RoleBuilder)((RoleFluent.RulesNested)((RoleFluent.RulesNested)((RoleFluent.RulesNested)((RoleBuilder)((RoleFluent.MetadataNested)new RoleBuilder().withNewMetadata().withName("pipeline-deployer")).endMetadata()).addNewRule().withApiGroups(new String[]{"", "apps", "extensions", "serving.knative.dev", "apps.openshift.io"})).withResources(new String[]{"deployments", "services", "ingresses", "serviceaccounts", "rolebindings", "persistentvolumeclaims", "configmaps", "secrets"})).withVerbs(new String[]{"get", "create", "update", "patch"})).endRule()).build();
    }

    public PipelineRun createPipelineRun(TektonConfig config) {
        try {
            return ((PipelineRunBuilder)((PipelineRunFluent.SpecNested)((PipelineRunFluent.SpecNested)((PipelineRunSpecFluent.ResourcesNested)((PipelineResourceBindingFluent.ResourceRefNested)((PipelineRunSpecFluent.ResourcesNested)((PipelineRunFluent.SpecNested)((PipelineRunSpecFluent.ResourcesNested)((PipelineResourceBindingFluent.ResourceRefNested)((PipelineRunSpecFluent.ResourcesNested)((PipelineRunFluent.SpecNested)((PipelineRunSpecFluent.PipelineRefNested)((PipelineRunFluent.SpecNested)((PipelineRunSpecFluent.WorkspacesNested)((PipelineRunSpecFluent.WorkspacesNested)((PipelineRunFluent.SpecNested)((PipelineRunBuilder)((PipelineRunFluent.MetadataNested)new PipelineRunBuilder().withNewMetadata().withName(config.getName() + DASH + RUN + DASH + NOW)).endMetadata()).withNewSpec().withServiceAccountName(TektonManifestGenerator.imageBuildTaskName(config))).addNewWorkspace().withName(PIPELINE_SOURCE_WS)).withNewPersistentVolumeClaim(TektonManifestGenerator.sourceWorkspaceClaimName(config), Boolean.valueOf(false))).endWorkspace()).withNewPipelineRef().withName(config.getName())).endPipelineRef()).addNewResource().withName(GIT_SOURCE)).withNewResourceRef().withName(TektonManifestGenerator.gitResourceName(config))).endResourceRef()).endResource()).addNewResource().withName(OUTPUT_IMAGE)).withNewResourceRef().withName(TektonManifestGenerator.outputImageResourceName(config))).endResourceRef()).endResource()).withTimeout(Duration.parse((String)DEFAULT_TIMEOUT))).endSpec()).build();
        }
        catch (Exception e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    public TaskRun createTaskRun(TektonConfig config) {
        try {
            return ((TaskRunBuilder)((TaskRunFluent.SpecNested)((TaskRunFluent.SpecNested)((TaskRunSpecFluent.ResourcesNested)((TaskRunResourcesFluent.OutputsNested)((TaskResourceBindingFluent.ResourceRefNested)((TaskRunResourcesFluent.OutputsNested)((TaskRunSpecFluent.ResourcesNested)((TaskRunResourcesFluent.InputsNested)((TaskResourceBindingFluent.ResourceRefNested)((TaskRunResourcesFluent.InputsNested)((TaskRunFluent.SpecNested)((TaskRunSpecFluent.TaskRefNested)((TaskRunFluent.SpecNested)((TaskRunSpecFluent.WorkspacesNested)((TaskRunSpecFluent.WorkspacesNested)((TaskRunFluent.SpecNested)((TaskRunBuilder)((TaskRunFluent.MetadataNested)new TaskRunBuilder().withNewMetadata().withName(config.getName() + DASH + RUN + DASH + NOW)).endMetadata()).withNewSpec().withServiceAccountName(TektonManifestGenerator.monolithTaskName(config))).addNewWorkspace().withName(config.getSourceWorkspace())).withEmptyDir(((EmptyDirVolumeSourceBuilder)new EmptyDirVolumeSourceBuilder().withMedium("Memory")).build())).endWorkspace()).withNewTaskRef().withName(TektonManifestGenerator.monolithTaskName(config))).endTaskRef()).withNewResources().addNewInput().withName(GIT_SOURCE)).withNewResourceRef().withName(TektonManifestGenerator.gitResourceName(config))).endResourceRef()).endInput()).addNewOutput().withName(IMAGE)).withNewResourceRef().withName(TektonManifestGenerator.outputImageResourceName(config))).endResourceRef()).endOutput()).endResources()).withTimeout(Duration.parse((String)DEFAULT_TIMEOUT))).endSpec()).build();
        }
        catch (Exception e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    public PersistentVolumeClaim createSourceWorkspacePvc(final TektonConfig config) {
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>(){
            {
                this.put("storage", ((QuantityBuilder)((QuantityBuilder)new QuantityBuilder().withAmount(config.getSourceWorkspaceClaim().getSize() != null ? String.valueOf(config.getSourceWorkspaceClaim().getSize()) : "1")).withFormat(config.getSourceWorkspaceClaim().getUnit() != null ? config.getSourceWorkspaceClaim().getUnit() : "Gi")).build());
            }
        };
        LabelSelector selector = null;
        if (config.getSourceWorkspaceClaim().getMatchLabels().length != 0) {
            selector = ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(Arrays.stream(config.getSourceWorkspaceClaim().getMatchLabels()).collect(Collectors.toMap(l -> l.getKey(), l -> l.getValue())))).build();
        }
        return ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName(TektonManifestGenerator.sourceWorkspaceClaimName(config))).endMetadata()).withNewSpec().withAccessModes(new String[]{config.getSourceWorkspaceClaim().getAccessMode() != null ? config.getSourceWorkspaceClaim().getAccessMode().name() : "ReadWriteOnce"})).withStorageClassName(config.getSourceWorkspaceClaim().getStorageClass())).withNewResources().withRequests((Map)requests)).endResources()).withSelector(selector)).endSpec()).build();
    }

    public PersistentVolumeClaim createM2WorkspacePvc(final TektonConfig config) {
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>(){
            {
                this.put("storage", ((QuantityBuilder)((QuantityBuilder)new QuantityBuilder().withAmount(String.valueOf(config.getM2WorkspaceClaim().getSize()))).withFormat(config.getM2WorkspaceClaim().getUnit())).build());
            }
        };
        LabelSelector selector = null;
        if (config.getM2WorkspaceClaim().getMatchLabels().length != 0) {
            selector = ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(Arrays.stream(config.getM2WorkspaceClaim().getMatchLabels()).collect(Collectors.toMap(l -> l.getKey(), l -> l.getValue())))).build();
        }
        return ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName(TektonManifestGenerator.m2WorkspaceClaimName(config))).endMetadata()).withNewSpec().withAccessModes(new String[]{config.getSourceWorkspaceClaim().getAccessMode() != null ? config.getSourceWorkspaceClaim().getAccessMode().name() : "ReadWriteOnce"})).withStorageClassName(config.getM2WorkspaceClaim().getStorageClass())).withNewResources().withRequests((Map)requests)).endResources()).withSelector(selector)).endSpec()).build();
    }

    public ConfigurationSupplier<TektonConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((TektonConfigBuilder)new TektonConfigBuilder().accept(new Visitor[]{new ApplyDeployToApplicationConfiguration()})).accept(new Visitor[]{new ApplyProjectInfo(p)}));
    }

    private static ImageConfiguration getImageConfiguration(Project project, TektonConfig tektonConfig, ConfigurationRegistry configurationRegistry) {
        return configurationRegistry.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> TektonManifestGenerator.merge(tektonConfig, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)tektonConfig));
    }

    private static ImageConfiguration merge(TektonConfig tektonConfig, ImageConfiguration imageConfig) {
        if (tektonConfig == null) {
            throw new NullPointerException("KubernetesConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)tektonConfig);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : tektonConfig.getProject())).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withName(imageConfig.getName() != null ? imageConfig.getName() : tektonConfig.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : tektonConfig.getVersion())).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : "docker.io")).withDockerFile(imageConfig.getDockerFile() != null ? imageConfig.getDockerFile() : "Dockerfile")).withAutoBuildEnabled(Boolean.valueOf(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false))).withAutoPushEnabled(Boolean.valueOf(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false))).build();
    }

    public static final String getDefaultBuildImage(TektonConfig config) {
        return null;
    }

    public static final String getDefaultBuildCommand(TektonConfig config) {
        return null;
    }

    public static final String[] getDefaultBuildArguments(TektonConfig config, String dockerfile, String context) {
        return null;
    }

    public static final boolean requiresPushStep(TektonConfig config) {
        return true;
    }

    public static final String getDefaultPushCommand(TektonConfig config) {
        return null;
    }

    public static final String[] getDefaultPushArguments(TektonConfig config, String dockerfile, String context) {
        return null;
    }

    public static final String getYamlPath(Project project) {
        Path module;
        Path root = project != null && project.getScmInfo() != null ? project.getScmInfo().getRoot() : null;
        Path path = module = project != null ? project.getRoot() : null;
        if (root != null && module != null) {
            return module.toAbsolutePath().resolve("target/classes/META-INF/dekorate/kubernetes.yml").toAbsolutePath().toString().substring(root.toAbsolutePath().toString().length() + 1);
        }
        return "target/classes/META-INF/dekorate/kubernetes.yml";
    }

    public static final String gitResourceName(TektonConfig config) {
        return Strings.isNotNullOrEmpty((String)config.getExternalGitPipelineResource()) ? config.getExternalGitPipelineResource() : config.getName() + DASH + GIT;
    }

    public static final String sourceWorkspaceClaimName(TektonConfig config) {
        return Strings.isNotNullOrEmpty((String)config.getExternalSourceWorkspaceClaim()) ? config.getExternalSourceWorkspaceClaim() : (Strings.isNotNullOrEmpty((String)config.getSourceWorkspaceClaim().getName()) ? config.getSourceWorkspaceClaim().getName() : config.getName());
    }

    public static final String m2WorkspaceClaimName(TektonConfig config) {
        return Strings.isNotNullOrEmpty((String)config.getExternalM2WorkspaceClaim()) ? config.getExternalM2WorkspaceClaim() : (Strings.isNotNullOrEmpty((String)config.getM2WorkspaceClaim().getName()) ? config.getM2WorkspaceClaim().getName() : null);
    }

    public static final String projectBuildStepName(TektonConfig config) {
        return "project-build";
    }

    public static final String outputImageResourceName(TektonConfig config) {
        return config.getName() + DASH + IMAGE;
    }

    public static final String imageBuildTaskName(TektonConfig config) {
        return config.getName() + DASH + IMAGE + DASH + BUILD;
    }

    public static final String imagePushTaskName(TektonConfig config) {
        return config.getName() + DASH + IMAGE + DASH + PUSH;
    }

    public static final String projectBuildTaskName(TektonConfig config) {
        return config.getName() + DASH + PROJECT + DASH + BUILD;
    }

    public static final String deployTaskName(TektonConfig config) {
        return config.getName() + DASH + DEPLOY;
    }

    public static final String monolithTaskName(TektonConfig config) {
        return config.getName() + DASH + BUILD + DASH + AND + DASH + DEPLOY;
    }
}

