/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.step;

import io.dekorate.tekton.step.ImageBuildStep;
import io.dekorate.tekton.util.TektonUtils;
import io.dekorate.utils.Strings;

public class DockerBuildStep
extends ImageBuildStep<DockerBuildStep> {
    public static final String BUILD = "build";
    public static final String PUSH = "push";
    public static final String TARGET = "--target";
    public static final String FILE = "--file";
    public static final String DOT = ".";
    public static final String DOCKERFILE_ARG = "$(inputs.params.pathToDockerfile)";
    public static final String CONTEXT_ARG = "$(inputs.params.pathToContext)";
    public static final String IMAGE_TARGET_ARG = "$(resources.outputs.image.url)";
    public static final String BUILD_IMAGE_PARAM_DEFAULT = "docker.io/docker:19.03.13";
    public static final String BUILD_COMMAND_PARAM_DEFAULT = "docker";
    public static final String PUSH_IMAGE_PARAM_DEFAULT = "docker";
    public static final String PUSH_COMMAND_PARAM_DEFAULT = "docker";

    public DockerBuildStep() {
        this(DOT, "Dockerfile", BUILD_IMAGE_PARAM_DEFAULT, "docker", DockerBuildStep.getDefaultBuildArguments("Dockerfile", TektonUtils.getContextPath()), "docker", "docker", DockerBuildStep.getDefaultPushArguments("Dockerfile", DOT));
    }

    public DockerBuildStep(String context, String dockerfile, String buildImage, String buildCommand, String[] buildArguments, String pushImage, String pushCommand, String[] pushArguments) {
        super(context, dockerfile, buildImage, buildCommand, buildArguments, pushImage, pushCommand, pushArguments);
    }

    @Override
    public DockerBuildStep withContext(String context) {
        return new DockerBuildStep(context, this.dockerfile, this.buildImage, this.buildCommand, DockerBuildStep.getDefaultBuildArguments(context, this.dockerfile), this.pushImage, this.pushCommand, DockerBuildStep.getDefaultPushArguments(context, this.dockerfile));
    }

    @Override
    public DockerBuildStep withDockerfile(String dockerfile) {
        return new DockerBuildStep(this.context, Strings.isNotNullOrEmpty((String)dockerfile) ? dockerfile : this.dockerfile, this.buildImage, this.buildCommand, DockerBuildStep.getDefaultBuildArguments(this.context, dockerfile), this.pushImage, this.pushCommand, DockerBuildStep.getDefaultPushArguments(this.context, dockerfile));
    }

    @Override
    public DockerBuildStep withBuildImage(String buildImage) {
        return new DockerBuildStep(this.context, this.dockerfile, Strings.isNotNullOrEmpty((String)buildImage) ? buildImage : this.buildImage, this.buildCommand, this.buildArguments, this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public DockerBuildStep withBuildCommand(String buildCommand) {
        return new DockerBuildStep(this.context, this.dockerfile, this.buildImage, Strings.isNotNullOrEmpty((String)buildCommand) ? buildCommand : this.buildCommand, this.buildArguments, this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public DockerBuildStep withBuildArguments(String[] buildArguments) {
        return new DockerBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, buildArguments != null && buildArguments.length > 0 ? buildArguments : this.buildArguments, this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public DockerBuildStep withPushImage(String pushImage) {
        return new DockerBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, this.buildArguments, Strings.isNotNullOrEmpty((String)pushImage) ? pushImage : this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public DockerBuildStep withPushCommand(String pushCommand) {
        return new DockerBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, this.buildArguments, this.pushImage, Strings.isNotNullOrEmpty((String)pushCommand) ? pushCommand : this.pushCommand, this.pushArguments);
    }

    @Override
    public DockerBuildStep withPushArguments(String[] pushArguments) {
        return new DockerBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, this.buildArguments, this.pushImage, this.pushCommand, pushArguments != null && pushArguments.length > 0 ? pushArguments : this.pushArguments);
    }

    @Override
    public boolean isPushRequired() {
        return true;
    }

    @Override
    public boolean isDockerSocketRequired() {
        return true;
    }

    private static String[] getDefaultBuildArguments(String context, String dockerfile) {
        return new String[]{BUILD, TARGET, IMAGE_TARGET_ARG, FILE, dockerfile, context};
    }

    private static String[] getDefaultPushArguments(String context, String dockerfile) {
        return new String[]{PUSH, IMAGE_TARGET_ARG};
    }
}

