/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.step;

import io.dekorate.tekton.step.Step;

public abstract class ImageBuildStep<T extends ImageBuildStep>
implements Step {
    public static final String ID = "image-build";
    public static final String PATH_TO_DOCKERFILE_PARAM_NAME = "pathToDockerfile";
    public static final String PATH_TO_DOCKERFILE_PARAM_DESCRIPTION = "Path to Dockerfile";
    public static final String PATH_TO_DOCKERFILE_PARAM_DEFAULT = "Dockerfile";
    public static final String IMAGE_PARAM_NAME = "imageBuilderImage";
    public static final String IMAGE_PARAM_DESCRIPTION = "The image to use for performing project build";
    public static final String IMAGE_PARAM_REF = "$(inputs.params.imageBuilderImage)";
    public static final String COMMAND_PARAM_NAME = "imageBuilderCommand";
    public static final String COMMAND_PARAM_DESCRIPTION = "The command to use for performing project build";
    public static final String COMMAND_PARAM_REF = "$(inputs.params.imageBuilderCommand)";
    public static final String ARGS_PARAM_NAME = "imageBuilderArgs";
    public static final String ARGS_PARAM_DESCRIPTION = "The command arguments to use for performing project build";
    public static final String ARGS_PARAM_REF = "$(inputs.params.imageBuilderArgs[*])";
    protected final String context;
    protected final String dockerfile;
    protected final String buildImage;
    protected final String buildCommand;
    protected final String[] buildArguments;
    protected final String pushImage;
    protected final String pushCommand;
    protected final String[] pushArguments;

    public ImageBuildStep(String context, String dockerfile, String buildImage, String buildCommand, String[] buildArguments, String pushImage, String pushCommand, String[] pushArguments) {
        this.context = context;
        this.dockerfile = dockerfile;
        this.buildImage = buildImage;
        this.buildCommand = buildCommand;
        this.buildArguments = buildArguments;
        this.pushImage = pushImage;
        this.pushCommand = pushCommand;
        this.pushArguments = pushArguments;
    }

    public abstract T withContext(String var1);

    public abstract T withDockerfile(String var1);

    public abstract T withBuildImage(String var1);

    public abstract T withBuildCommand(String var1);

    public abstract T withBuildArguments(String[] var1);

    public abstract T withPushImage(String var1);

    public abstract T withPushCommand(String var1);

    public abstract T withPushArguments(String[] var1);

    public boolean isPushRequired() {
        return false;
    }

    public boolean isDockerSocketRequired() {
        return false;
    }

    public String getContext() {
        return this.context;
    }

    public String getDockerfile() {
        return this.dockerfile;
    }

    public String getBuildImage() {
        return this.buildImage;
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    public String[] getBuildArguments() {
        return this.buildArguments;
    }

    public String getPushImage() {
        return this.pushImage;
    }

    public String getPushCommand() {
        return this.pushCommand;
    }

    public String[] getPushArguments() {
        return this.pushArguments;
    }
}

