/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.step;

import io.dekorate.tekton.step.ImageBuildStep;
import io.dekorate.tekton.util.TektonUtils;
import io.dekorate.utils.Strings;

public class KanikoBuildStep
extends ImageBuildStep<KanikoBuildStep> {
    public static final String DOCKERFILE_FORMAT = "--dockerfile=%s";
    public static final String DOCKERFILE_ARG = "--dockerfile=$(inputs.params.pathToDockerfile)";
    public static final String CONTEXT_FORMAT = "--context=%s";
    public static final String CONTEXT_ARG = "--context=$(params.pathToContext)";
    public static final String IMAGE_DESTINATION_ARG = "--destination=$(resources.outputs.image.url)";
    public static final String BUILD_IMAGE_PARAM_DEFAULT = "gcr.io/kaniko-project/executor:v1.3.0";
    public static final String BUILD_COMMAND_PARAM_DEFAULT = "/kaniko/executor";
    public static final String PUSH_IMAGE_PARAM_DEFAULT = "/kaniko/executor";
    public static final String PUSH_COMMAND_PARAM_DEFAULT = "/kaniko/executor";

    public KanikoBuildStep() {
        this(".", "Dockerfile", BUILD_IMAGE_PARAM_DEFAULT, "/kaniko/executor", KanikoBuildStep.getDefaultBuildArguments("Dockerfile", TektonUtils.getContextPath()), null, null, null);
    }

    public KanikoBuildStep(String context, String dockerfile, String buildImage, String buildCommand, String[] buildArguments, String pushImage, String pushCommand, String[] pushArguments) {
        super(context, dockerfile, buildImage, buildCommand, buildArguments, pushImage, pushCommand, pushArguments);
    }

    @Override
    public KanikoBuildStep withContext(String context) {
        return new KanikoBuildStep(context, this.dockerfile, this.buildImage, this.buildCommand, KanikoBuildStep.getDefaultBuildArguments(context, this.dockerfile), null, null, null);
    }

    @Override
    public KanikoBuildStep withDockerfile(String dockerfile) {
        return new KanikoBuildStep(this.context, Strings.isNotNullOrEmpty((String)dockerfile) ? dockerfile : this.dockerfile, this.buildImage, this.buildCommand, KanikoBuildStep.getDefaultBuildArguments(this.context, dockerfile), null, null, null);
    }

    @Override
    public KanikoBuildStep withBuildImage(String buildImage) {
        return new KanikoBuildStep(this.context, this.dockerfile, Strings.isNotNullOrEmpty((String)buildImage) ? buildImage : this.buildImage, this.buildCommand, this.buildArguments, this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public KanikoBuildStep withBuildCommand(String buildCommand) {
        return new KanikoBuildStep(this.context, this.dockerfile, this.buildImage, Strings.isNotNullOrEmpty((String)buildCommand) ? buildCommand : this.buildCommand, this.buildArguments, this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public KanikoBuildStep withBuildArguments(String[] buildArguments) {
        return new KanikoBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, buildArguments != null && buildArguments.length > 0 ? buildArguments : this.buildArguments, this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public KanikoBuildStep withPushImage(String pushImage) {
        return new KanikoBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, this.buildArguments, Strings.isNotNullOrEmpty((String)pushImage) ? pushImage : this.pushImage, this.pushCommand, this.pushArguments);
    }

    @Override
    public KanikoBuildStep withPushCommand(String pushCommand) {
        return new KanikoBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, this.buildArguments, this.pushImage, Strings.isNotNullOrEmpty((String)pushCommand) ? pushCommand : this.pushCommand, this.pushArguments);
    }

    @Override
    public KanikoBuildStep withPushArguments(String[] pushArguments) {
        return new KanikoBuildStep(this.context, this.dockerfile, this.buildImage, this.buildCommand, this.buildArguments, this.pushImage, this.pushCommand, pushArguments != null && pushArguments.length > 0 ? pushArguments : this.pushArguments);
    }

    @Override
    public boolean isPushRequired() {
        return false;
    }

    private static String[] getDefaultBuildArguments(String context, String dockerfile) {
        return new String[]{String.format(DOCKERFILE_FORMAT, dockerfile), String.format(CONTEXT_FORMAT, context), IMAGE_DESTINATION_ARG};
    }
}

