package io.determann.shadow.api.shadow;

import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;

/**
 * represents primitive types, but not there wrapper classes. for example int, long, short
 */
public interface Primitive extends Shadow<PrimitiveType>
{
   /**
    * returns true if this can be cast to that.
    * This can be useful if you want to check if a shadow implements for example a
    * {@link java.util.Collection} {@code shadowToTest.erasure().isSubtypeOf(shadowApi.getDeclaredOrThrow("java.util.Collection").erasure())}
    */
   boolean isSubtypeOf(Shadow<? extends TypeMirror> shadow);

   /**
    * Equivalent to {@link #isSubtypeOf(Shadow)} except for primitives.
    * if one is a primitive and the other is not it tries to convert them
    */
   boolean isAssignableFrom(Shadow<? extends TypeMirror> shadow);

   /**
    * int -&gt; Integer<br>
    * long -&gt; Long
    * etc...
    */
   Class asBoxed();

   /**
    * int -&gt; int[]
    */
   Array asArray();

   /**
    * be careful using this equals
    *
    * @see #representsSameType(Shadow)
    */
   @Override
   boolean equals(Object obj);
}
