package com.igaworks.v2.core.result;

import android.content.Context;

import java.util.HashMap;

import io.adbrix.sdk.utils.CommonUtils;

public class OnDeferredDeeplinkResult extends ResultWithDeeplink {
    public enum Result{
        CONVERSION(0),
        ORGANIC(1),
        ORGANIC_POLICY_VIOLATION(2),
        ORGANIC_IN_NCPI_PROGRESS(3),
        NO_CONVERSION(-1),
        UNKNOWN_ERROR(-255);
        private static final HashMap<Integer, OnDeferredDeeplinkResult.Result> valueMap = new HashMap<>();
        static {
            for(OnDeferredDeeplinkResult.Result value : values()){
                valueMap.put(value.getValue(), value);
            }
        }
        private final int value;
        Result(int value){
            this.value = value;
        }
        public static OnDeferredDeeplinkResult.Result getResultByValue(int value){
            Result result = valueMap.get(value);
            if(CommonUtils.isNull(result)){
                return UNKNOWN_ERROR;
            }
            return result;
        }
        public int getValue() {
            return value;
        }
    }
    private final int resultCode;
    public OnDeferredDeeplinkResult(Context context, String deeplink, int resultCode) {
        super.context = context;
        super.deeplink = deeplink;
        this.resultCode = resultCode;
    }

    public OnDeferredDeeplinkResult.Result getResult() {
        return OnDeferredDeeplinkResult.Result.getResultByValue(resultCode);
    }

    @Override
    public String toString() {
        return "OnDeferredDeeplinkResult{" +
                "result=" + getResult() +
                ", deeplink='" + deeplink + '\'' +
                '}';
    }
}
