package com.igaworks.v2.core.result;

import org.json.JSONException;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.model.SubscriptionStatus;
import io.adbrix.sdk.utils.CommonUtils;

public class SetCiProfileResult extends CiPropertyResult {
    public SetCiProfileResult(int statusCode, int result) {
        super.statusCode = statusCode;
        super.result_code = result;
    }
    public SetCiProfileResult(int statusCode, String responseBody) {
        super.statusCode = statusCode;
        if(CommonUtils.isNullOrEmpty(responseBody)){
            return;
        }
        try {
            NullableJSONObject jsonObject = new NullableJSONObject(responseBody);
            super.result_code = jsonObject.optInt(SubscriptionStatus.RESPONSE_RESULT_CODE);
            super.result_msg = jsonObject.optString(SubscriptionStatus.RESPONSE_RESULT_MSG);
        } catch (JSONException e) {
            AbxLog.w(e, false);
        }
    }

    @Override
    public String toString() {
        return "SetCiProfileResult{" +
                "statusCode=" + statusCode +
                ", result_code=" + result_code +
                ", result_msg='" + result_msg + '\'' +
                '}';
    }
}
