//package io.adbrix.sdk.component;
//
//import android.content.Context;
//import android.content.pm.ApplicationInfo;
//import android.content.pm.PackageManager;
//import android.os.Build;
//import android.util.Log;
//
//import io.adbrix.sdk.data.S3ConfigHandler;
//import io.adbrix.sdk.data.entity.DataRegistryKey;
//import io.adbrix.sdk.data.entity.DataUnit;
//import io.adbrix.sdk.data.modelprovider.AppScanModelProvider;
//import io.adbrix.sdk.data.net.ApiConnection;
//import io.adbrix.sdk.data.net.ApiConnectionManager;
//import io.adbrix.sdk.data.repository.DataRegistry;
//import io.adbrix.sdk.domain.ABXConstants;
//import io.adbrix.sdk.domain.model.IApiModel;
//import io.adbrix.sdk.utils.CommonUtils;
//
//import org.json.JSONArray;
//import org.json.JSONObject;
//
//import java.io.File;
//import java.util.Date;
//import java.util.List;
//
//public class AbxAppScanHandler {
//    private Context mContext;
//    private PackageManager packageManager;
//    private long nextAppScanUploadTime = -1;
//    private DataRegistry dataRegistry;
//
//    public AbxAppScanHandler(DataRegistry dataRegistry) {
//        this.dataRegistry = dataRegistry;
//    }
//
//    public void abxApplicationScan(Context context){
//        mContext = context;
//        if (packageManager == null) packageManager = mContext.getPackageManager();
//        if (packageManager == null) {
//            AbxLog.w("Appscan: Error : Can't call get PackageManager API", true);
//            return;
//        }
//
//        final JSONArray appPackageJSON = new JSONArray();
//        JSONObject pacakgeElementJSON;
//        String category;
//        List<ApplicationInfo> list = packageManager.getInstalledApplications(PackageManager.GET_META_DATA);
//        if (list != null && Build.VERSION.SDK_INT < 26) {
//            AbxLog.d("Error :: Can't get category of application under the API version 26", false);
//        }
//        for (ApplicationInfo info : list) {
//            try {
//                if (null != packageManager.getLaunchIntentForPackage(info.packageName)) {
//                    if ((info.flags & ApplicationInfo.FLAG_SYSTEM) != 0) continue;
//                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
//                        switch (info.category) {
//                            case ApplicationInfo.CATEGORY_AUDIO:
//                                category = "audio";
//                                break;
//                            case ApplicationInfo.CATEGORY_VIDEO:
//                                category = "video";
//                                break;
//                            case ApplicationInfo.CATEGORY_IMAGE:
//                                category = "image";
//                                break;
//                            case ApplicationInfo.CATEGORY_SOCIAL:
//                                category = "social";
//                                break;
//                            case ApplicationInfo.CATEGORY_NEWS:
//                                category = "news";
//                                break;
//                            case ApplicationInfo.CATEGORY_MAPS:
//                                category = "maps";
//                                break;
//                            case ApplicationInfo.CATEGORY_PRODUCTIVITY:
//                                category = "productivity";
//                                break;
//                            default:
//                                category = "undefiend";
//                                break;
//                        }
//                    } else {
//                        category = "undefiend";
//                    }
//                    try {
//                        JSONObject appProperties = new JSONObject();
//                        pacakgeElementJSON = new JSONObject();
//                        pacakgeElementJSON.put("package_name", info.packageName)
//                                .put("install_datetime", CommonUtils.getUTC_DBFormat(packageManager.getPackageInfo(info.packageName, 0).firstInstallTime))
//                                .put("update_datetime", CommonUtils.getUTC_DBFormat(new File(info.sourceDir).lastModified()))
//                                .put("category", category);
//                        if (appProperties != null) pacakgeElementJSON.put("app_properties", appProperties);
//                        appPackageJSON.put(pacakgeElementJSON);
//                    } catch (PackageManager.NameNotFoundException e) {
//                        e.printStackTrace();
//                    }
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        }
//
//        requestAppScan(appPackageJSON);
//    }
//
//    private void requestAppScan(JSONArray appPackageJSON) {
//        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY,null);
//
//        if (CommonUtils.canConnectBackend(mContext) && appKey != null) {
//            AbxLog.d("AppScanning Start!", true);
//            try {
//                ApiConnectionManager apiConnectionManager = new ApiConnectionManager(new ApiConnectionManager.Result() {
//                    @Override
//                    public void connectSuccess(String responseString) {
//                        AbxLog.d("AppScanning Success !! " + responseString , true);
//                        AbxLog.d("Appscan: Received callback message : Success", true);
//                        setNextAppScanTime();
//                    }
//
//                    @Override
//                    public void connectFail() {
//                        AbxLog.w("API appScanning connectFail !!", true);
//                        AbxLog.d("Appscan: Received callback message : Fail", true);
//                        setNextAppScanTime();
//                    }
//                });
//
//                IApiModel appScanModel = new AppScanModelProvider(dataRegistry, appPackageJSON).provide();
//
//                ApiConnection apiConnection = new ApiConnection(dataRegistry, mContext)
//                        .POST(appScanModel);
//
//                apiConnectionManager.ExecuteWithRetry(apiConnection);
//
//            } catch (Exception e) {
//                Log.e(ABXConstants.LOGTAG, "API Error: " + e.getMessage());
//                AbxLog.e("App Scan Request Error: " + e.getMessage(), true);
//            }
//        } else {
//            AbxLog.w("AbxApplicationScan: Cannot Run ", true);
//            AbxLog.w("AbxApplicationScan: can connect backend : " + CommonUtils.canConnectBackend(mContext), true);
//            AbxLog.w("AbxApplicationScan - appkey " + appKey, true);
//        }
//    }
//
//    public boolean checkIsTimeToAppScan() //gdpr 되어있으면 All Stop
//    {
//        if (nextAppScanUploadTime == -1) {
//            nextAppScanUploadTime = dataRegistry.safeGetLong(DataRegistryKey.LONG_NEXT_APP_SCAN_TIME, -1);
//        }
//        if (nextAppScanUploadTime == -1) { // there is no value in DB, first time of app opening
//            AbxLog.d("Application Scanning : We will send app_scanning event. (first time)", true);
//            return true;
//        } else {
//            if (nextAppScanUploadTime <= System.currentTimeMillis()) {
//                AbxLog.d("Application Scanning : We will send app-scanning event.", true);
//                return true;
//            } else {
//                AbxLog.d("Application Scanning : Not yet to send..." + (nextAppScanUploadTime - System.currentTimeMillis()) / 1000 + "seconds left", true);
//            }
//        }
//        return false;
//    }
//
//    private void setNextAppScanTime() {
//        AbxLog.d("Application Scanning : setNextAppScanTime :Set next uploading time calculated with current time and period", true);
//
//        long calculatedNextUploadTime = System.currentTimeMillis() + S3ConfigHandler.config_appScanPeriod;
//        AbxLog.d("Application Scanning : current date : " + new Date(), true);
//        AbxLog.d("Application Scanning : calculated next-date of app-scanning : " + new Date(calculatedNextUploadTime), true);
//
//        nextAppScanUploadTime = calculatedNextUploadTime;
//        dataRegistry.putDataRegistry(
//                new DataUnit(
//                        DataRegistryKey.LONG_NEXT_APP_SCAN_TIME,
//                        calculatedNextUploadTime,
//                        5,
//                        this.getClass().getName(),
//                        true
//                )
//        );
//    }
//
//    public boolean getAppScanStatus() {
//        boolean isUserEnabledAppScan = dataRegistry.safeGetLong(DataRegistryKey.LONG_APP_SCAN_ON_OFF_USER, -1) == 1;
//        return isUserEnabledAppScan && !S3ConfigHandler.config_appScanStop;
//    }
//}
