package io.adbrix.sdk.component;

import android.util.Log;

import java.util.HashSet;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IPairObserver;

//Test 클래스에서 사용하는 로거입니다.
public class ConsoleLogger implements IPairObserver<Integer,String> {

    HashSet<Integer> stackTraceLevels = new HashSet<>();

    public ConsoleLogger(int... stackTraceLevel){
        if(stackTraceLevel != null)
        {
            for(int traceLevel : stackTraceLevel){
                stackTraceLevels.add(traceLevel);
            }
        }
    }

    public static final String RESET = "\033[0m";  // Text Reset
    public static final String BLACK = "\033[0;30m";   // BLACK
    public static final String RED = "\033[0;31m";     // RED
    public static final String GREEN = "\033[0;32m";   // GREEN
    public static final String YELLOW = "\033[0;33m";  // YELLOW
    public static final String BLUE = "\033[0;34m";    // BLUE
    public static final String PURPLE = "\033[0;35m";  // PURPLE
    public static final String CYAN = "\033[0;36m";    // CYAN
    public static final String WHITE = "\033[0;37m";   // WHITE

    @Override
    public void update(Integer level, String message) {
        String colorCode = RESET;
        String levelText = ""+level;

        switch (level)
        {
            case Log.ASSERT:
            {
                levelText="ASSERT";
                colorCode = PURPLE;
                break;
            }
            case Log.DEBUG:
            {
                levelText="DEBUG";
                colorCode=WHITE;
                break;
            }
            case Log.ERROR:
            {
                levelText="ERROR";
                colorCode= RED;
                break;
            }
            case Log.INFO:
            {
                levelText="INFO";
                colorCode=CYAN;
                break;
            }
            case Log.VERBOSE:
            {
                levelText="VERBOSE";
                colorCode=GREEN;
                break;
            }
            case Log.WARN:
            {
                levelText="WARN";
                colorCode=YELLOW;
                break;
            }
        }
        System.out.printf("%s[%s]:%s%s\n",colorCode,levelText,message,RESET);

        if(stackTraceLevels.contains(level))
        {
            Throwable t = new Throwable();
            t.printStackTrace(System.out);
        }
    }
}
