package io.adbrix.sdk.data.entity;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.model.IDataModel;

public class DataUnit implements IDataModel {

    public final DataRegistryKey key;
    public final DataType dataType;
    public final String srcValue;
    public final int priority;
    public final String provider;
    public final boolean isPersistence;
    public DataUnit(
            DataRegistryKey key,
            Object srcValue,
            int priority,
            String provider,
            boolean isPersistence
    ) {
        this.key = key;
        this.dataType = this.key.getDataType();
        this.srcValue = srcValue == null ? null : srcValue.toString();
        this.priority = priority;
        this.provider = provider;
        this.isPersistence = isPersistence;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject root = new NullableJSONObject();
        root.put("key", this.key.getId());
        root.put("src_value", this.srcValue);
        root.put("priority", this.priority);
        root.put("provider", this.provider);
        root.put("is_persistence", this.isPersistence);

        return root;
    }

    public int getInt() throws DataUnitInvalidTypeCastingException {
        if (this.dataType != DataType.INT)
            throw new DataUnitInvalidTypeCastingException();

        return Integer.parseInt(this.srcValue);
    }

    public String getString() throws DataUnitInvalidTypeCastingException {
        if (this.dataType != DataType.STRING)
            throw new DataUnitInvalidTypeCastingException();

        return this.srcValue;
    }

    public boolean getBoolean() throws DataUnitInvalidTypeCastingException {
        if (this.dataType != DataType.BOOLEAN)
            throw new DataUnitInvalidTypeCastingException();

        return Boolean.parseBoolean(this.srcValue);
    }

    public float getFloat() throws DataUnitInvalidTypeCastingException {
        if (this.dataType != DataType.FLOAT)
            throw new DataUnitInvalidTypeCastingException();

        return Float.parseFloat(this.srcValue);
    }

    public long getLong() throws DataUnitInvalidTypeCastingException {
        if (this.dataType != DataType.LONG)
            throw new DataUnitInvalidTypeCastingException();

        return Long.parseLong(this.srcValue);
    }

    public double getDouble() throws DataUnitInvalidTypeCastingException {
        if (this.dataType != DataType.DOUBLE)
            throw new DataUnitInvalidTypeCastingException();

        return Double.parseDouble(this.srcValue);
    }

    public static class DataUnitInvalidTypeCastingException extends Exception {

    }
}
