//package io.adbrix.sdk.data.modelprovider;
//
//import io.adbrix.sdk.data.entity.DataRegistryKey;
//import io.adbrix.sdk.data.repository.DataRegistry;
//import io.adbrix.sdk.domain.model.AppScanModel;
//import io.adbrix.sdk.domain.model.IApiModel;
//import io.adbrix.sdk.utils.CommonUtils;
//
//import org.json.JSONArray;
//import org.json.JSONException;
//import org.json.JSONObject;
//
//import java.util.UUID;
//
//public class AppScanModelProvider implements IApiModelProvider{
//    private DataRegistry dataRegistry;
//    private JSONArray appPackageJSON;
//
//    public AppScanModelProvider(DataRegistry dataRegistry, JSONArray appPackageJSON){
//        this.dataRegistry = dataRegistry;
//        this.appPackageJSON = appPackageJSON;
//    }
//
//    @Override
//    public IApiModel provide() {
//        final JSONObject obj = new JSONObject();
//        final JSONObject common = new JSONObject();
//
//        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY,null);
//        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID,null);
//
//        try {
//            common.put("request_datetime", CommonUtils.getCurrentUTCInDBFormat());
//            common.put("adid", CommonUtils.replaceWithJSONNull(adid));
//            common.put("platform", "and");
//            common.put("appkey", appKey);
//
//            obj.put("common", common);
//            obj.put("records", appPackageJSON);
//            obj.put("request_id", UUID.randomUUID().toString());
//
//        } catch (JSONException e){
//            e.printStackTrace();
//        }
//
//        return new AppScanModel(
//                common,
//                appPackageJSON,
//                UUID.randomUUID().toString()
//        );
//    }
//}
