package io.adbrix.sdk.data.modelprovider;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;

import java.util.Arrays;
import java.util.List;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.OsPushEnableObservable;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.model.CommonModel;
import io.adbrix.sdk.domain.model.DeviceModel;
import io.adbrix.sdk.domain.model.IdentityModel;
import io.adbrix.sdk.utils.CommonUtils;

public class CommonModelProvider implements IDataModelProvider<CommonModel> {
    private DataRegistry dataRegistry;
    private Context androidContext;
    private DeviceRealtimeDataProvider deviceRealtimeDataProvider;

    public CommonModelProvider(DataRegistry dataRegistry, Context androidContext, DeviceRealtimeDataProvider deviceRealtimeDataProvider) {
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
        this.deviceRealtimeDataProvider = deviceRealtimeDataProvider;
    }

    @Override
    public CommonModel provide() {
        deviceRealtimeDataProvider.refreshData();

        boolean isPushEnableOs = getOsPushEnable(androidContext);
        IdentityModel identityModel = new IdentityModel(
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null),
                getQaGaid(androidContext) != null ? getQaGaid(androidContext) : getRealGaid(),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_UUID, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_IDFA, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_IDFV, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_IGAW_ID, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_DFN_ID, null),
                this.dataRegistry.safeGetBoolean(DataRegistryKey.BOOLEAN_AD_ID_OPT_OUT, false),
                null,
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_REGISTRATION_ID, null),
                this.dataRegistry.safeGetBoolean(DataRegistryKey.BOOLEAN_IS_PUSH_ENABLE, false),
                isPushEnableOs
        );
        OsPushEnableObservable.getInstance().notifyObserver(isPushEnableOs);

        DeviceModel deviceModel = new DeviceModel(
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_OS, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_MODEL, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_VENDOR, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_RESOLUTION, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_PLATFORM, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_CARRIER, null),
                this.dataRegistry.safeGetInt(DataRegistryKey.INT_TIME_ZONE_OFFSET, 0),
                this.dataRegistry.safeGetInt(DataRegistryKey.INT_DEVICE_TIME_TYPE, 0),
                this.dataRegistry.safeGetBoolean(DataRegistryKey.BOOLEAN_IS_WIFI_ONLY, false),
                this.dataRegistry.safeGetBoolean(DataRegistryKey.BOOLEAN_IS_PORTRAIT, false),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_NETWORK, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_LANGUAGE, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_COUNTRY, null),
                this.dataRegistry.safeGetInt(DataRegistryKey.INT_BATT_L, 0),
                this.dataRegistry.safeGetBoolean(DataRegistryKey.BOOLEAN_BATT_C, false)
        );

        CommonModel commonModel = new CommonModel(
                CommonUtils.getCurrentUTCInDBFormat(),
                identityModel,
                deviceModel,
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_PACKAGE_NAME, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_API_VERSION, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_SDK_VERSION, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_INSTALLER, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_APP_VERSION, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_BUILD_ID, null)
        );

        return commonModel;
    }

    /**
     * @see <a href="https://developer.android.com/about/versions/13/changes/notification-permission?hl=ko#check-app-can-send">앱에서 알림을 보낼 수 있는지 확인</a>
     * @param context
     * @return
     */
    private boolean getOsPushEnable(Context context) {
        boolean value = true;
        try {
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N) {
                return value;
            }
            NotificationManager manager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            if(!manager.areNotificationsEnabled()){
                value = false;
                return value;
            }
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O){
                return value;
            }
            List<NotificationChannel> list = manager.getNotificationChannels();
            if(list.size() == 0){
                value = false;
                return value;
            }
        }catch (Exception e){
            AbxLog.e(e, true);
            value = false;
        }
        return value;
    }

    private String getQaGaid(Context context) {
        try {
            ApplicationInfo appInfo;
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;
            return bundle.getString("AdbrixQaGaid");
        } catch (Exception e) {
            AbxLog.e(e, true);
            return null;
        }
    }

    private String getRealGaid() {
        return this.dataRegistry.safeGetString(DataRegistryKey.STRING_GAID, null);
    }
}
