package io.adbrix.sdk.data.modelprovider;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.SetCiPropertyModel;
import io.adbrix.sdk.domain.model.SetSubscriptionStatusModel;
import io.adbrix.sdk.domain.model.SubscriptionStatus;

public class SetCiPropertyModelProvider implements IApiModelProvider<SetCiPropertyModel> {
    private final String key;
    private final String value;
    private final DataRegistry dataRegistry;

    public SetCiPropertyModelProvider(String key, String value, DataRegistry dataRegistry) {
        this.key = key;
        this.value = value;
        this.dataRegistry = dataRegistry;
    }

    @Override
    public SetCiPropertyModel provide() {
        return new SetCiPropertyModel(this.key, this.value, this.dataRegistry);
    }
}
