package io.adbrix.sdk.domain;

import android.app.Activity;

import com.igaworks.v2.core.AdBrixRm;

import org.json.JSONObject;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.EventModel;
import io.adbrix.sdk.domain.model.IAMEnums;
import io.adbrix.sdk.domain.model.SelfServeInAppMessage;
import io.adbrix.sdk.domain.model.Response;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.ResultCallback;
import io.adbrix.sdk.domain.model.SubscriptionStatus;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public interface Repository {
    EventModel getEventModel(LogEventParameter logEventParameter);

    Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);

    void clearUserProperty();

    void getUserId(Completion<Result<String>> completion);

//    void syncApplicationConfigure();

    void gdprForgetMe();

    //    void updateFavoriteApplication();

    void saveUnsentEvents();

    void logEvent(LogEventParameter logEventParameter);

    void logSameEventWithPaging(String eventName, String group, List<JSONObject> eventParams);

    void flushAllNow(Completion<Result<Empty>> completion);

    void flushAtIntervals();

    //InAppMessage
    void resetInAppMessageFrequencySession();


    void shutDownInAppMessageExecutor();

    void updateCurrentActivity(Activity activity);

    void deleteCurrentActivity(Activity activity);

    void dismissInAppMessageDialog(Activity destroyedActivity, IAMEnums.CloseType closeType);

    void fetchInAppMessage(boolean isDirectCall, Completion<Result<Empty>> completion);

    void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion);
    void getSelfServeInAppMessages(AdBrixRm.GetSelfServeInAppMessagesCallback callback);

    void openInAppMessage(String eventName);
    void openInAppMessage(String eventName, JSONObject eventParam);
    void openInAppMessage(String eventName, List<JSONObject> eventParamList);
    void openInAppMessage(String campaignId, Completion<Result<Empty>> completion);

    void deleteAllInAppMessageDBContents();

    void deleteAllUserInAppMessageDBcontents();

    //DRWorks
    void deleteUserData(String userId, ResultCallback<String> callback);

    void restartSDK(String userId, boolean enableAdidTracking, ResultCallback<String> callback);

    //ActionHistory
    void fetchActionHistoryFromServer(@Nullable String token, ActionHistoryIdType idType, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void insertPushData(String pushDataString);

    void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void deleteActionHistory(@Nullable String token, String historyId, long timestamp, Completion<Result<Empty>> completion);

    void deleteAllActionHistory(@Nullable String token, @Nullable ActionHistoryIdType idType, Completion<Result<Empty>> completion);

    void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion);

    void clearAllActionHistoryInLocalDB();

    void loadDFNId();

    //KT
    void startTvAttributionBeacon(String dfnId);

    //SKB
    void sendDataToSkBroadbandSetTopBox();

    boolean isLoginIdMatched(String loginId);
    String getLoginId();
    //public boolean isInAppMessageUserFetchMode();
    void login(String userId, Completion<Result<Response>> completion);
    void logout(Completion<Result<Response>> completion);
    void requestGetAttributionData(String logId, AdBrixRm.GetAttributionDataCallback callback, DataRegistry dataRegistry);
    void getSubscriptionStatus(AdBrixRm.GetSubscriptionStatusCallback callback, DataRegistry dataRegistry);
    void setSubscriptionStatus(SubscriptionStatus subscriptionStatus, AdBrixRm.SetSubscriptionStatusCallback callback, DataRegistry dataRegistry);
    void setCiProperty(String key, String value, AdBrixRm.SetCiProfileCallback callback, DataRegistry dataRegistry);
}
