package io.adbrix.sdk.domain.interactor;

import java.util.List;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Result;

public class GetActionHistoryUseCase implements UseCase<Void> {
    private final Repository repository;
    private final int skip;
    private final int limit;
    private final List<String> actionType;
    private final Completion<Result<List<ActionHistory>>> completion;

    public GetActionHistoryUseCase(
            Repository repository,
            int skip,
            int limit,
            List<String> actionType,
            Completion<Result<List<ActionHistory>>> completion
    ) {
        this.repository = repository;
        this.skip = skip;
        this.limit = limit;
        this.actionType = actionType;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.getActionHistory(skip, limit, actionType, completion);
        return null;
    }
}
