package io.adbrix.sdk.domain.interactor;

import com.igaworks.v2.core.AdBrixRm;

import java.util.List;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.SelfServeInAppMessage;
import io.adbrix.sdk.domain.model.Result;

public class GetAllSelfServeInAppMessagesUseCase implements UseCase<Empty> {
    private final Repository repository;
    private final AdBrixRm.GetSelfServeInAppMessagesCallback callback;

    public GetAllSelfServeInAppMessagesUseCase(Repository repository, AdBrixRm.GetSelfServeInAppMessagesCallback callback) {
        this.repository = repository;
        this.callback = callback;
    }

    @Override
    public Empty execute() {
        repository.getSelfServeInAppMessages(callback);
        return Empty.INSTANCE;
    }
}
