package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Response;
import io.adbrix.sdk.domain.model.Result;

public class LoginUseCase implements UseCase<Void> {
    private Repository repository;
    private String userId;
    private Completion<Result<Response>> completion;

    public LoginUseCase(Repository repository, String userId, Completion<Result<Response>> completion) {
        this.repository = repository;
        this.userId = userId;
        this.completion = completion;
    }

    @Override
    public Void execute() throws UnsupportedOperationException {
        repository.login(userId, completion);
        return null;
    }
}
