package io.adbrix.sdk.domain.interactor;

import com.igaworks.v2.core.AdBrixRm;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.Repository;

public class RequestGetAttributionDataUseCase implements UseCase<Void>{
    private final String logId;
    private final AdBrixRm.GetAttributionDataCallback callback;
    private final DataRegistry dataRegistry;
    private final Repository repository;

    public RequestGetAttributionDataUseCase(String logId, AdBrixRm.GetAttributionDataCallback callback, DataRegistry dataRegistry, Repository repository) {
        this.logId = logId;
        this.callback = callback;
        this.dataRegistry = dataRegistry;
        this.repository = repository;
    }

    @Override
    public Void execute() {
        repository.requestGetAttributionData(logId, callback, dataRegistry);
        return null;
    }
}
