package io.adbrix.sdk.domain.model;

public enum ActionHistoryError {
    DELETE_LOCAL_DB_FAIL_ERROR("DeleteActionHistoryError :: Delete Action History in Local DB Fail!"),
    DELETE_REMOTE_DB_FAIL_ERROR("DeleteActionHistoryError :: Delete Action History in Remote DB Fail!"),
    SYNC_SERVER_ERROR("ActionHistory server sync failed!"),
    NULL_RESPONSE_ERROR("Response data is null!"),
    NO_JSON_VALUE_ERROR("JSON data does not contain required value."),
    OPEN_DATABASE_ERROR("Cannot open ActionHistory database."),
    SDK_DISABLED_STATE_ERROR("Disabled된 ABX SDK의 Method가 호출되었습니다."),
    NULL_ID_ERROR("ADID or userID cannot be null when deleting action history!"),
    NULL_ACTION_HISTORY_API_MODEL_ERROR("ActionHistory API Model is null!"),
    NO_APPKEY_ERROR("No appKey in dataRegistry"),
    SQLITE_QUERY_ERROR("Error occurred while executing sqlite query.");

    private final String errorMessage;

    ActionHistoryError(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public <T> Error<T> getError() {
        return Error.of(errorMessage);
    }
}
