package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.utils.CommonUtils;

/**
 * 2023.01.11 bobos
 * Attribution API @see("https://www.notion.so/dfinery/Attribution-API-Feat-Adobe-Analysis-2e91dbe2ff2e40f3bc3898c92c5cc344")
 */
public class AttributionModel implements IApiModel{
    public static final String REQUEST_AD_ID = "adid";
    public static final String REQUEST_LAST_OPEN_ID = "log_id";

    public static final String RESPONSE_RESULT = "result";
    public static final String RESPONSE_ATTRIBUTION_RESULT = "attribution_result";
    public static final String RESPONSE_EVT_LOG_ID = "evt_log_id";
    public static final String RESPONSE_SERVER_DATETIME = "server_datetime";
    public static final String RESPONSE_ADTOUCH_DATETIME = "adtouch_datetime";
    public static final String RESPONSE_ATTRIBUTE_DATETIME = "attribute_datetime";
    public static final String RESPONSE_EVENT_DATETIME = "event_datetime";
    public static final String RESPONSE_PARTNER = "partner";
    public static final String RESPONSE_PARTNER_NAME = "partner_name";
    public static final String RESPONSE_TRACKER_ID = "tracker_id";
    public static final String RESPONSE_TRACKER_NAME = "tracker_name";
    public static final String RESPONSE_CAMPAIGN_ID = "campaign_id";
    public static final String RESPONSE_CAMPAIGN_NAME = "campaign_name";
    public static final String RESPONSE_I_REQUEST_TYPE = "i_request_type";
    public static final String RESPONSE_ATTR_TYPE = "attr_type";
    public static final String RESPONSE_FRAUD_REASON = "fraud_reason";
    public static final String RESPONSE_M_PUBLISHER = "m_publisher";
    public static final String RESPONSE_M_ADGROUP = "m_adgroup";
    public static final String RESPONSE_M_AD = "m_ad";
    public static final String RESPONSE_M_KEYWORD = "m_keyword";
    public static final String RESPONSE_M_PLACEMENT = "m_placement";
    public static final String RESPONSE_M_COST_MODEL = "m_cost_model";
    public static final String RESPONSE_M_COST = "m_cost";
    public static final String RESPONSE_M_COST_CURRENCY = "m_cost_currency";
    public static final String RESPONSE_M_PLAY_PERCENT = "m_play_percent";
    public static final String RESPONSE_M_PLAY_SECOND = "m_play_second";
    public static final String RESPONSE_M_VIEW_PERCENT = "m_view_percent";
    public static final String RESPONSE_M_VIEW_SECOND = "m_view_second";
    public static final String RESPONSE_M_CREATIVE = "m_creative";
    public static final String RESPONSE_M_SUB_PUBLISHER = "m_sub_publisher";
    public static final String RESPONSE_M_CAMPAIGN = "m_campaign";
    public static final String RESPONSE_M_RANK = "m_rank";
    public static final String RESPONSE_M_CAMPAIGN_TYPE = "m_campaign_type";
    public static final String RESPONSE_M_MEDIA = "m_media";
    public static final String RESPONSE_M_KEYWORD_ID = "m_keyword_id";
    public static final String RESPONSE_M_CONTRACT = "m_contract";
    public static final String RESPONSE_M_NETWORK = "m_network";
    public static final String RESPONSE_M_MATCH = "m_match";
    public static final String RESPONSE_M_AD_EXTENSION = "m_ad_extension";
    public static final String RESPONSE_M_ADGROUP_ID = "m_adgroup_id";
    public static final String RESPONSE_M_CAMPAIGN_ID = "m_campaign_id";
    public static final String RESPONSE_M_CAMPAIGN_GROUP_ID = "m_campaign_group_id";
    public static final String RESPONSE_M_CAMPAIGN_GROUP = "m_campaign_group";
    public static final String RESPONSE_M_ACCOUNT_ID = "m_account_id";
    public static final String RESPONSE_UTM_SOURCE = "utm_source";
    public static final String RESPONSE_UTM_MEDIUM = "utm_medium";
    public static final String RESPONSE_UTM_CAMPAIGN = "utm_campaign";
    public static final String RESPONSE_UTM_TERM = "utm_term";
    public static final String RESPONSE_UTM_CONTENT = "utm_content";
    public static final String RESPONSE_ADV_ADGROUP = "adv_adgroup";
    public static final String RESPONSE_ADV_AD = "adv_ad";
    public static final String RESPONSE_ADV_CAMPAIGN = "adv_campaign";
    public static final String RESPONSE_ADV_CREATIVE = "adv_creative";
    public static final String RESPONSE_ADV_KEYWORD = "adv_keyword";
    public static final String RESPONSE_ADV_AGENCY = "adv_agency";
    public static final String RESPONSE_ADV_PLACEMENT = "adv_placement";
    public static final String RESPONSE_ADV_COST_MODEL = "adv_cost_model";
    public static final String RESPONSE_ADV_COST = "adv_cost";
    public static final String RESPONSE_ADV_CURRENCY = "adv_currency";

    private String logId;
    private DataRegistry dataRegistry;

    public AttributionModel(String logId, DataRegistry dataRegistry) {
        this.logId = logId;
        this.dataRegistry = dataRegistry;
    }

    @Override
    public String getUrlString() {
        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null);
        return String.format(CoreConstants.attributionUrl, appKey);
    }

    @Override
    public JSONObject getJson() throws JSONException {
        String adId = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);
        String lastOpenId = dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_OPEN_ID, null);
        if(!CommonUtils.isNullOrEmpty(logId)){
            lastOpenId = logId;
        }
        NullableJSONObject jsonObject = new NullableJSONObject();
        jsonObject.put(REQUEST_AD_ID, adId);
        jsonObject.put(REQUEST_LAST_OPEN_ID, lastOpenId);
        return jsonObject;
    }
}
