package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.CoreConstants;

public class DFNIDModel implements IApiModel {
    private final IdentityModel identityModel;
    private final DeviceModel deviceModel;
    private final String requestDatetime;

    public DFNIDModel(IdentityModel identityModel, DeviceModel deviceModel, String requestDatetime) {
        this.identityModel = identityModel;
        this.deviceModel = deviceModel;
        this.requestDatetime = requestDatetime;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.dfnIdUrl;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject result = new NullableJSONObject();
        result.put("identity", identityModel.getJson());
        result.put("device_info", deviceModel.getJson());
        result.put("request_datetime", requestDatetime);

        return result;
    }
}
