package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.utils.CoreUtils;

public class DeviceModel implements IDataModel {
    public String os;
    public String model;
    public String vendor;
    public String resolution;
    public String platform;
    public String carrier;
    public int timeZoneOffset;
    public int deviceTimeType;
    public Boolean isWifiOnly;
    // EventModel로 migration이 예정되어 있는 property들
    public boolean isPortrait;
    public String network;
    public String language;
    public String country;
    public int battL;
    public boolean battC;

    public DeviceModel(
            String os,
            String model,
            String vendor,
            String resolution,
            String platform,
            String carrier,
            int timeZoneOffset,
            int deviceTimeType,
            Boolean isWifiOnly,
            boolean isPortrait,
            String network,
            String language,
            String country,
            int battL,
            boolean battC
    ) {
        this.os = os;
        this.model = model;
        this.vendor = vendor;
        this.resolution = resolution;
        this.platform = platform;
        this.carrier = carrier;
        this.timeZoneOffset = timeZoneOffset;
        this.deviceTimeType = deviceTimeType;
        this.isWifiOnly = isWifiOnly;
        this.isPortrait = isPortrait;
        this.network = network;
        this.language = language;
        this.country = country;
        this.battL = battL;
        this.battC = battC;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject root = new NullableJSONObject();

        root.put("os", this.os);
        root.put("model", this.model);
        root.put("vendor", this.vendor);
        root.put("resolution", this.resolution);
        root.put("is_portrait", this.isPortrait);
        root.put("platform", this.platform);
        root.put("network", this.network);
        root.put("carrier", this.carrier);
        root.put("language", this.language);
        root.put("country", this.country);
        root.put("time_zone_offset", this.timeZoneOffset);
        root.put("device_time_type", this.deviceTimeType);
        root.put("is_wifi_only", this.isWifiOnly);
        root.put("batt_l", this.battL);
        root.put("batt_c", this.battC);

        return root;
    }
}
