package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.domain.IAMConstants;

public class DfnGrowthEventParam implements IDataModel {
    public final String campaignId;
    public final int campaignRevisionNo;
    public final String stepId;
    public final String cycleTime;

    public DfnGrowthEventParam(String campaignId, int campaignRevisionNo, String stepId, String cycleTime) {
        this.campaignId = campaignId;
        this.campaignRevisionNo = campaignRevisionNo;
        this.stepId = stepId;
        this.cycleTime = cycleTime;
    }

    @Override
    public NullableJSONObject getJson() throws JSONException {
        NullableJSONObject root = new NullableJSONObject();

        root.put(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_ID, campaignId);
        root.put(ABXConstants.GROWTH_EVENT_KEY_CYCLE_TIME, cycleTime);
        root.put(ABXConstants.GROWTH_EVENT_KEY_STEP_ID, stepId);

        if (campaignRevisionNo != -1)
            root.put(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_REVISION_NO, campaignRevisionNo);

        return root;
    }

    public static DfnGrowthEventParam fromJSON(String extConfig) {
        try {
            JSONObject extConfigJson = new JSONObject(extConfig);
            JSONObject growthScenarioJson = extConfigJson.getJSONObject(IAMConstants.RESPONSE_IAM_EXT_CONFIG_GROWTH_SCENARIO);

            String campaignId = growthScenarioJson.optString(IAMConstants.RESPONSE_IAM_EXT_CONFIG_GROWTH_SCENARIO_CAMPAIGN_ID);
            int campaignRevisionNo = growthScenarioJson.optInt(IAMConstants.RESPONSE_IAM_EXT_CONFIG_GROWTH_SCENARIO_CAMPAIGN_REVISION_NO, -1);
            String stepId = growthScenarioJson.optString(IAMConstants.RESPONSE_IAM_EXT_CONFIG_GROWTH_SCENARIO_STEP_ID).equals("") ? null
                    : growthScenarioJson.optString(IAMConstants.RESPONSE_IAM_EXT_CONFIG_GROWTH_SCENARIO_STEP_ID);
            String cycleTime = growthScenarioJson.optString(IAMConstants.RESPONSE_IAM_EXT_CONFIG_GROWTH_SCENARIO_CYCLE_TIME).equals("") ? null
                    : growthScenarioJson.optString(IAMConstants.RESPONSE_IAM_EXT_CONFIG_GROWTH_SCENARIO_CYCLE_TIME);

            return new DfnGrowthEventParam(campaignId, campaignRevisionNo, stepId, cycleTime);
        } catch (Exception e) {
//            AbxLog.w(e, true);
            return null;
        }
    }

    @Override
    public String toString() {
        try {
            return getJson().toString();
        } catch (JSONException e) {
            return "";
        }
    }
}
