package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;

public class GetSubscriptionStatusModel extends SubscriptionStatus implements IApiModel{
    public static final String REQUEST_APP_KEY = "appkey";
    public static final String REQUEST_USER_ID = "user_id";
    public static final String REQUEST_ADID = "adid";
    public static final String REQUEST_PROPERTY_NAMES = "property_names";

    private DataRegistry dataRegistry;

    public GetSubscriptionStatusModel(DataRegistry dataRegistry) {
        this.dataRegistry = dataRegistry;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.getUserProfileUrl;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null);
        String userId = dataRegistry.safeGetString(DataRegistryKey.STRING_USER_ID, null);
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);
        JSONArray propertyNames = new JSONArray();
        propertyNames.put(SubscriptionStatus.INFORMATIVE_NOTIFICATION_FLAG);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_PUSH_CHANNEL);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_SMS_CHANNEL);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_KAKAO_CHANNEL);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_PUSH_CHANNEL);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_SMS_CHANNEL);
        propertyNames.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_KAKAO_CHANNEL);

        NullableJSONObject jsonObject = new NullableJSONObject();
        jsonObject.put(REQUEST_APP_KEY, appKey);
        jsonObject.put(REQUEST_USER_ID, userId);
        jsonObject.put(REQUEST_ADID, adid);
        jsonObject.put(REQUEST_PROPERTY_NAMES, propertyNames);
        return jsonObject;
    }
}
