package io.adbrix.sdk.domain.model;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.function.Completion;

public interface Result<T> {

    boolean isSucceeded();
    T getOrDefault(T other);
    @Nullable
    T getOrNull();
    Result<T> onSuccess(Completion<T> completion);
    Result<T> onFailure(Completion<Throwable> completion);
    void onComplete(Runnable action);
    String toString();
}
