package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;

public class SetSubscriptionStatusModel extends SubscriptionStatus implements IApiModel{
    public static final String REQUEST_APP_KEY = "appkey";
    public static final String REQUEST_USER_ID = "user_id";
    public static final String REQUEST_ADID = "adid";
    public static final String REQUEST_PROPERTIES = "properties";

    private SubscriptionStatus subscriptionStatus;
    private DataRegistry dataRegistry;

    public SetSubscriptionStatusModel(SubscriptionStatus subscriptionStatus, DataRegistry dataRegistry) {
        this.subscriptionStatus = subscriptionStatus;
        this.dataRegistry = dataRegistry;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.setUserProfileUrl;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null);
        String userId = dataRegistry.safeGetString(DataRegistryKey.STRING_USER_ID, null);
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);
        JSONObject requestProperties = new JSONObject();
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getInformativeNotificationFlag())){
            requestProperties.put(SubscriptionStatus.INFORMATIVE_NOTIFICATION_FLAG, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getInformativeNotificationFlag()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationFlag())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationFlag()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationFlagForPushChannel())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_PUSH_CHANNEL, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationFlagForPushChannel()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationFlagForSmsChannel())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_SMS_CHANNEL, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationFlagForSmsChannel()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationFlagForKakaoChannel())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_KAKAO_CHANNEL, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationFlagForKakaoChannel()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationAtNightFlag())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationAtNightFlag()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationAtNightFlagForPushChannel())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_PUSH_CHANNEL, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationAtNightFlagForPushChannel()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationAtNightFlagForSmsChannel())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_SMS_CHANNEL, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationAtNightFlagForSmsChannel()));
        }
        if(subscriptionStatus.isSetAvailableSubscriptionType(subscriptionStatus.getMarketingNotificationAtNightFlagForKakaoChannel())){
            requestProperties.put(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_KAKAO_CHANNEL, subscriptionStatus.getStringBySubscriptionStatus(subscriptionStatus.getMarketingNotificationAtNightFlagForKakaoChannel()));
        }
        NullableJSONObject jsonObject = new NullableJSONObject();
        jsonObject.put(REQUEST_APP_KEY, appKey);
        jsonObject.put(REQUEST_USER_ID, userId);
        jsonObject.put(REQUEST_ADID, adid);
        jsonObject.put(REQUEST_PROPERTIES, requestProperties);
        return jsonObject;
    }
}
