package io.adbrix.sdk.ui.inappmessage;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.IABXContextController;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.ui.inappmessage.webview.DefaultInAppMessageViewFactory;
import io.adbrix.sdk.utils.CommonUtils;

public class InAppMessageFactoryContainer {

    public static final String FULL_SCREEN = "full_screen";
    public static final String MODAL = "modal";
    public static final String STICKY_BANNER = "sticky_banner";

    private final InAppMessageDAO inAppMessageDAO;
    private final IABXContextController abxContextController;

    public InAppMessageFactoryContainer(InAppMessageDAO inAppMessageDAO, IABXContextController abxContextController) {
        this.inAppMessageDAO = inAppMessageDAO;
        this.abxContextController = abxContextController;
    }

    public IInAppMessageViewFactory getInAppMessageViewFactory(DfnInAppMessage inAppMessage) {
        if(inAppMessage == null){
            AbxLog.w("inAppMessage is null", true);
            InAppMessageManager.getInstance().setIsInProgress(false);
            return null;
        }
        if(CommonUtils.isNullOrEmpty(inAppMessage.getType())){
            AbxLog.w("inAppMessage Type is null or empty", true);
            InAppMessageManager.getInstance().setIsInProgress(false);
            return null;
        }

        switch (inAppMessage.getType()) {
            case FULL_SCREEN:
            case MODAL:
            case STICKY_BANNER:
                return new DefaultInAppMessageViewFactory(inAppMessageDAO, abxContextController);
            default:
                AbxLog.w("Invalid in app message type. Cannot get factory.", true);
                InAppMessageManager.getInstance().setIsInProgress(false);
                return null;
        }
    }
}
