package io.adbrix.sdk.ui.inappmessage;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.RelativeLayout;

import java.lang.ref.WeakReference;

import io.adbrix.sdk.domain.model.IAMEnums;

public class InAppMessageView extends RelativeLayout {
    private WeakReference<InAppMessageViewListener> inAppMessageViewListenerReference;
    private InAppMessageViewListener inAppMessageViewListener;

    public InAppMessageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {

            }
        });
    }

    public void setInAppMessageViewListener(InAppMessageViewListener inAppMessageViewListener) {
        this.inAppMessageViewListener = inAppMessageViewListener;
        this.inAppMessageViewListenerReference = new WeakReference<>(inAppMessageViewListener);
    }

    public InAppMessageViewListener getInAppMessageViewListener() {
        return inAppMessageViewListenerReference.get();
    }

    public void finishView(){
        this.inAppMessageViewListener = null;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK){
            //click back button
            if(InAppMessageManager.getInstance().isInProgress()){
                return super.onKeyDown(keyCode, event);
            }
            InAppMessageManager.getInstance().close(IAMEnums.CloseType.KEY_DOWN_KEYCODE_BACK);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if(isInTouchMode()){
            return super.dispatchKeyEvent(event);
        }
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK){
            //touch back button
            if(InAppMessageManager.getInstance().isInProgress()){
                return super.dispatchKeyEvent(event);
            }
            InAppMessageManager.getInstance().close(IAMEnums.CloseType.KEY_DOWN_KEYCODE_BACK);
            return true;
        }
        return super.dispatchKeyEvent(event);
    }
}
