package io.adbrix.sdk.ui.inappmessage;

import android.os.Build;
import android.view.View;
import android.view.WindowInsets;

/**
 * 2022.12.13 bobos
 * android.support 라이브러리 의존성 줄이기위해 android.support.v4 28.0.0 버전 가져와서 씀
 */
public class ViewCompat {
    public static void requestApplyInsets(View view) {
        if (Build.VERSION.SDK_INT >= 20) {
            view.requestApplyInsets();
        } else if (Build.VERSION.SDK_INT >= 16) {
            view.requestFitSystemWindows();
        }
    }
    public static void setOnApplyWindowInsetsListener(View v, final OnApplyWindowInsetsListener listener) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (listener == null) {
                v.setOnApplyWindowInsetsListener((android.view.View.OnApplyWindowInsetsListener)null);
                return;
            }

            v.setOnApplyWindowInsetsListener(new android.view.View.OnApplyWindowInsetsListener() {
                public WindowInsets onApplyWindowInsets(View view, WindowInsets insets) {
                    WindowInsetsCompat compatInsets = WindowInsetsCompat.wrap(insets);
                    compatInsets = listener.onApplyWindowInsets(view, compatInsets);
                    return (WindowInsets) WindowInsetsCompat.unwrap(compatInsets);
                }
            });
        }
    }
}
