package io.adbrix.sdk.ui.push.components;



import org.json.JSONArray;
import org.json.JSONException;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.AbxFacade;

public class AbxPushCommonDAO {
    /*
    DB에 설정 세팅.
    세팅이 되어있지 않다면 디폴트값 리턴
     */

    //TODO : 일단 스태틱(이곳에 모든 메소드가 스태틱이다 ;_;)으로 종속성 역전, 추후 클래스로 생명주기 관리
    private IPushEventStore pushEventStore;
    private AbxFacade abxFacade;

    public AbxPushCommonDAO(AbxFacade abxFacade,IPushEventStore pushEventStore) {
        this.abxFacade = abxFacade;
        this.pushEventStore = pushEventStore;
    }

    public void setPushIconStyle(String smallIconName, String largeIconName, int argb) {
        abxFacade.setPushIconStyle(smallIconName, largeIconName, argb);
    }

    public void setNotificationOption(int priority, int visibility) {
        abxFacade.setNotificationOption(priority, visibility);
    }

    public String getSmallIconName() {
        return abxFacade.getSmallIconName();
    }

    public String getLargeiconName() {
        return abxFacade.getLargeiconName();
    }

    public int getARGB() {
        return abxFacade.getARGB();
    }

    public int getPriority() {
        return abxFacade.getPriority();
    }

    public int getVisibility() {
        return abxFacade.getVisibility();
    }

    public int getImportance() {
        return abxFacade.getImportance();
    }

    protected void setStackingNotificationOption(boolean useStacking, boolean useTitleForStacking, String contentTitle, String contentText, String bigContentTitle, String bigContentSummaryText) {
        abxFacade.setStackingNotificationOption(useStacking, useTitleForStacking, contentTitle, contentText, bigContentTitle, bigContentSummaryText);
    }

    protected boolean getUseStacking() {
        return abxFacade.getUseStacking();
    }

    public boolean getUseTitleforStacking() {
        return abxFacade.getUseTitleforStacking();
    }

    public String getStackingContentTitle() {
        return abxFacade.getStackingContentTitle();
    }

    public String getStackingContentText() {
        return abxFacade.getStackingContentText();
    }

    public String getStackingBigContentTitle() {
        return abxFacade.getStackingBigContentTitle();
    }

    public String getStackingBigContentSummaryText() {
        return abxFacade.getStackingBigContentSummaryText();
    }

    public void setNotificationChannel(String channelName, String channelDescription,
                                              int importance, boolean vibrateEnable) {
        abxFacade.setNotificationChannel(channelName, channelDescription, importance, vibrateEnable);
    }

    public String getNotificationChannelName() {
        return abxFacade.getNotificationChannelName();
    }

    public String getNotificationChannelDescription() {
        return abxFacade.getNotificationChannelDescription();
    }

    public int getNotificationChannelLight() {
        return abxFacade.getNotificationChannelLight();
    }

    public int getNotificationChannelVibrate() {
        return abxFacade.getNotificationChannelVibrate();
    }

    public void insertOrReplacePushEvent(String title, String content, int eventId, long notificationTime, int isStacked) {
        pushEventStore.insertOrReplacePushEventToTableAndGetId(title, content, eventId, notificationTime, isStacked);
    }

    public JSONArray getPushEventList() {
        try {
            return pushEventStore.getPushEventList();
        } catch (JSONException e) {
            AbxLog.e(e, true);
            return new JSONArray();
        }
    }

    public JSONArray getStackedPushList(int isStacked) {
        try {
            return pushEventStore.getPushEventList(isStacked);
        } catch (JSONException e) {
            AbxLog.e(e, true);
            return null;
        }
    }

    protected void updatePushEventState(int id, boolean state) {
        pushEventStore.updatePushEventState(id, state);
    }

    public long deletePushEvent(int eventId) {
        return pushEventStore.deletePushEvent(eventId);
    }

    protected void flushStackedPushList() {
        JSONArray temp = getStackedPushList(1);
        for (int i = 0; i < temp.length(); i++) {
            try {
                updatePushEventState((int) (temp.getJSONObject(i).get("id")), false);
            } catch (JSONException e) {
                AbxLog.e(e, true);
            }
        }
    }
}
