package io.adbrix.sdk.ui.push.components;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.result.OnLocalPushClickResult;
import com.igaworks.v2.core.result.OnRemotePushClickResult;

import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.ui.push.models.BigTextPushProperties;
import io.adbrix.sdk.utils.CommonUtils;

public class PushController {
    private static PushController INSTANCE;
    public static PushController getInstance(){
        if(INSTANCE == null){
            INSTANCE = new PushController();
        }
        return INSTANCE;
    }
    public interface onTouchLocalPushListener {
        void onTouchLocalPush(String callbackJsonString);
    }
    public interface onTouchRemotePushListener {
        void onTouchRemotePush(String callbackJsonString);
    }

    private onTouchRemotePushListener remotePushMessageListener;
    private onTouchLocalPushListener localPushMessageListener;
    private AdBrixRm.onRemotePushClickListener remotePushClickListener;
    private AdBrixRm.onLocalPushClickListener localPushClickListener;
    private AbxFacade abxFacade;

    private PushController(){}

    public void init(AbxFacade abxFacade) {
        this.abxFacade = abxFacade;
        AbxLog.d("PushController are initialized!", true);
    }

    public void setRemotePushMessageListener(onTouchRemotePushListener remotePushMessageListener) {
        this.remotePushMessageListener = remotePushMessageListener;
    }

    public void setLocalPushMessageListener(onTouchLocalPushListener localPushMessageListener) {
        this.localPushMessageListener = localPushMessageListener;
    }

    public void setRemotePushClickListener(AdBrixRm.onRemotePushClickListener remotePushClickListener) {
        this.remotePushClickListener = remotePushClickListener;
    }

    public void setLocalPushClickListener(AdBrixRm.onLocalPushClickListener localPushClickListener) {
        this.localPushClickListener = localPushClickListener;
    }

    public void callBackLocalPushMsg(String msg) {
        if(this.localPushMessageListener == null){
            AbxLog.w("LocalPushMessageListener is null", false);
            return;
        }
        this.localPushMessageListener.onTouchLocalPush(msg);
    }
    public void callBackLocalPushMsg(Context context, JSONObject jsonObject){
        if(CommonUtils.isNull(this.localPushClickListener)){
            AbxLog.w("onLocalPushClickListener is null", false);
            return;
        }
        String deeplink = jsonObject.optString("deepLinkUri");
        if(CommonUtils.isNullOrEmpty(deeplink)){
            deeplink = "";
        }
        this.localPushClickListener.onClick(new OnLocalPushClickResult(context, deeplink));
    }

    public void callBackRemotePushMsg(String msg) {
        if(this.remotePushMessageListener == null){
            AbxLog.w("RemotePushMessageListener is null", false);
            return;
        }
        this.remotePushMessageListener.onTouchRemotePush(msg);
    }

    public void callBackRemotePushMsg(Context context, AdBrixRm.AbxRemotePushModel pushModel){
        if(CommonUtils.isNull(this.remotePushClickListener)){
            AbxLog.w("onRemotePushClickListener is null", false);
            return;
        }
        this.remotePushClickListener.onClick(new OnRemotePushClickResult(context, pushModel));
    }

    public boolean isPushAvailable(){
        boolean result = false;
        try {
            result = abxFacade.isPushAvailable();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }
    public boolean isDuplicatedNotification(int notificationId){
        boolean result = false;
        try {
            result = abxFacade.checkDuplicatedNotification(notificationId);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    public void processPushOpen(Intent intent){
        abxFacade.processPushOpen(intent);
    }

    public void showNotification(Context context, Intent intent){
        abxFacade.showNotification(context, intent);
    }

    public void pushEventTracking(JSONObject pushOpenParam){
        abxFacade.pushEventTracking(pushOpenParam);
    }

    public boolean isForeground(){
        return abxFacade.isForeground();
    }

    public void insertPushData(String pushDataString){
        abxFacade.insertPushData(pushDataString);
    }
}
