package io.adbrix.sdk.ui.push.models;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;

public class BigPicturePushProperties extends PushProperties {

    protected String bigPictureUrl;
    protected int resourceId;

    public BigPicturePushProperties() {
        this.bigPictureUrl = "";
        this.resourceId = 0;
    }

    public static BigPicturePushProperties fromJSONObject(JSONObject jsonObject) {

        BigPicturePushProperties bigPicturePushProperties = new BigPicturePushProperties();
        bigPicturePushProperties.setFromJSONObject(jsonObject);
        return bigPicturePushProperties;
    }

    public BigPicturePushProperties setFromJSONObject(JSONObject jsonObject){
        setSecond(jsonObject.optLong("second",0));
        setEventId(jsonObject.optInt("eventId",0));
        setResourceId(jsonObject.optInt("resourceId",0));
        setTitle(jsonObject.optString("title"));
        setContentText(jsonObject.optString("contentText"));
        setSummaryText(jsonObject.optString("summaryText"));
        setBigContentTitle(jsonObject.optString("bigContentTitle"));
        setBigPictureUrl(jsonObject.optString("bigPictureUrl"));
        setDeepLinkUri(jsonObject.optString("deepLinkUri"));
        return this;
    }

    public int getResourceId() {
        return resourceId;
    }

    public BigPicturePushProperties setResourceId(int resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getBigPictureUrl() {
        return bigPictureUrl;
    }

    public BigPicturePushProperties setBigPictureUrl(String bigPictureUrl) {
        this.bigPictureUrl = bigPictureUrl;
        return this;
    }

    public BigPicturePushProperties setTitle(String title) {
        this.title = title;
        return this;
    }

    public BigPicturePushProperties setSecond(long second) {
        this.second = second;
        return this;
    }

    public BigPicturePushProperties setContentText(String contentText) {
        this.contentText = contentText;
        return this;
    }

    public BigPicturePushProperties setSummaryText(String summaryText) {
        this.summaryText = summaryText;
        return this;
    }

    public BigPicturePushProperties setBigContentTitle(String bigContentTitle) {
        this.bigContentTitle = bigContentTitle;
        return this;
    }

    public BigPicturePushProperties setEventId(int eventId) {
        this.eventId = eventId;
        return this;
    }

    public BigPicturePushProperties setDeepLinkUri(String deepLinkUri) {
        this.deepLinkUri = deepLinkUri;
        return this;
    }

    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        try {
            obj
                .put("second", second)
                .put("eventId", eventId)
                .put("resourceId", resourceId)
                .put("title", title)
                .put("contentText", contentText)
                .put("summaryText", summaryText)
                .put("bigContentTitle", bigContentTitle)
                .put("bigPictureUrl", bigPictureUrl)
                .put("deepLinkUri", deepLinkUri);
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }
        return obj;
    }
}
