package io.adbrix.sdk.utils;

import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.TranslateAnimation;

public class AnimationUtils {
    public static Animation createVerticalAnimation(float fromY, float toY, long duration, boolean accelerate){
        Animation animation = new TranslateAnimation(
                Animation.RELATIVE_TO_PARENT, 0.0f,
                Animation.RELATIVE_TO_PARENT, 0.0f,
                Animation.RELATIVE_TO_SELF, fromY,
                Animation.RELATIVE_TO_SELF, toY);
        animation = setAnimationParams(animation, duration, accelerate);
        return animation;
    }

    public static Animation createHorizontalAnimation(float fromX, float toX, long duration, boolean accelerate){
        Animation animation = new TranslateAnimation(
                Animation.RELATIVE_TO_SELF, fromX,
                Animation.RELATIVE_TO_SELF, toX,
                Animation.RELATIVE_TO_PARENT, 0.0f,
                Animation.RELATIVE_TO_PARENT, 0.0f);
        animation = setAnimationParams(animation, duration, accelerate);
        return animation;
    }

    private static Animation setAnimationParams(Animation animation, long duration, boolean accelerate){
        animation.setDuration(duration);
        if(accelerate){
            animation.setInterpolator(new AccelerateInterpolator());
        } else{
            animation.setInterpolator(new DecelerateInterpolator());
        }
        return animation;
    }
}
