package io.adbrix.sdk.utils;

import com.igaworks.v2.core.result.GetAttributionDataResult;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.model.EventData;

public class PostbackUtils {
    static final String ADBRIX_ATTRIBUTION_PREFIX = "adbrix.";
    static final String EVENT_DEEPLINK = CoreConstants.GROUP_ABX+":"+CoreConstants.EVENT_DEEPLINK_OPEN;
    static final String EVENT_START_SESSION = CoreConstants.GROUP_ABX+":"+CoreConstants.EVENT_START_SESSION;
    static final String EVENT_START_SESSION_PARAM_KEY = "abx:open_type";
    static final String PARAM_VALUE_FIRST_OPEN = "string:first_open";
    static final String PARAM_VALUE_DEEPLINK_OPEN = "string:deeplink_open";

    static final String VALUE_TRUE = "true";
    static final String VALUE_FALSE = "false";
    static final String VALUE_PARAM_PREFIX = "param.";
    static final String VALUE_PARAM_ITEMS_PREFIX = VALUE_PARAM_PREFIX+"abx:item.";

    public static Map<String, String> setKeyPrefix(Map<String, String> attributionParams) {
        return setKeyPrefix(attributionParams, ADBRIX_ATTRIBUTION_PREFIX);
    }

    public static Map<String, String> setKeyPrefix(Map<String, String> attributionParams, String prefix){
        Map<String, String> newConversionMap = new HashMap<>();
        for (Map.Entry<String, String> entry : attributionParams.entrySet()) {
            if (entry.getValue() != null) {
                String newKey = prefix + entry.getKey();
                newConversionMap.put(newKey, entry.getValue());
            } else {
                String newKey = prefix + entry.getKey();
                newConversionMap.put(newKey, null);
            }
        }
//        Log.d("abxex", newConversionMap.toString());
        return newConversionMap;
    }

    public static boolean isRefreshAttributionDataEvent(EventData eventData){
        boolean result = false;
        if(isDeeplinkOpenEvent(eventData)){
            result = true;
            return result;
        }
        if(isStartSessionWithDeeplinkEvent(eventData)){
            result = true;
            return result;
        }
        return result;
    }

    public static boolean isDeeplinkOpenEvent(EventData eventData){
        boolean result = false;
        if(EVENT_DEEPLINK.equals(eventData.getEventName())){
            result = true;
        }
        return result;
    }
    public static boolean isStartSessionWithDeeplinkEvent(EventData eventData){
        boolean result = false;
        if(!EVENT_START_SESSION.equals(eventData.getEventName())){
            return result;
        }
        Map<String,Object> param = eventData.getParam();
        if(!param.containsKey(EVENT_START_SESSION_PARAM_KEY)){
            return result;
        }
        try {
            String paramValue = (String)param.get(EVENT_START_SESSION_PARAM_KEY);
            if(PARAM_VALUE_FIRST_OPEN.equals(paramValue)){
                result = true;
                return result;
            }
            if(PARAM_VALUE_DEEPLINK_OPEN.equals(paramValue)){
                result = true;
                return result;
            }
        }catch (Exception e){
            return result;
        }
        return result;
    }

    public static boolean hasItemsParam(EventData eventData){
        boolean result = false;
        Map<String, Object> param = eventData.getParam();
        if(CommonUtils.isNullOrEmpty(param)){
            return result;
        }
        if(!param.containsKey(CompatConstants.ABX_ITEMS)){
            return result;
        }
        result = true;
        return result;
    }

    public static List<JSONObject> getItemsParam(EventData eventData){
        List<JSONObject> list = new ArrayList<>();
        Map<String, Object> param = eventData.getParam();
        try {
            JSONArray items = (JSONArray) param.get(CompatConstants.ABX_ITEMS);
            for(int i=0; i<items.length(); i++){
                JSONObject jsonObject = items.getJSONObject(i);
                list.add(jsonObject);
            }
        }catch (Exception e){
            AbxLog.w(e, true);
        }
        return list;
    }

    public static void putEventDataToMapWithoutParam(Map<String, String> map, EventData eventData){
        map.put("event_datetime", eventData.getEventDatetime());
        map.put("event_name", eventData.getEventName());
        map.put("log_id",eventData.getLogId());
        map.put("package_name",eventData.getPackageName());
        map.put("appkey",eventData.getAppkey());
        map.put("api_version",eventData.getApiVersion());
        map.put("sdk_version",eventData.getSdkVersion());
        map.put("installer",eventData.getInstaller());
        map.put("app_version",eventData.getAppVersion());
        map.put("build_id",eventData.getBuildId());
        map.put("gaid",eventData.getGaid());
        map.put("idfa",eventData.getIdfa());
        map.put("idfv",eventData.getIdfv());
        map.put("ad_id_opt_out",getValueByBoolean(eventData.isAdIdOptOut()));
        map.put("os",eventData.getOs());
        map.put("model",eventData.getModel());
        map.put("vendor",eventData.getVendor());
        map.put("resolution",eventData.getResolution());
        map.put("platform",eventData.getPlatform());
        map.put("carrier",eventData.getCarrier());
        map.put("is_portrait",getValueByBoolean(eventData.isPortrait()));
        map.put("network",eventData.getNetwork());
        map.put("language",eventData.getLanguage());
        map.put("country",eventData.getCountry());
    }

    public static void putParamToMapWithoutItems(Map<String, String> map, EventData eventData){
        Map<String, Object> param = eventData.getParam();
        if(CommonUtils.isNullOrEmpty(param)){
            return;
        }
        putParamToMapWithoutItems(map, param);
    }

    public static void putParamToMapWithoutItems(Map<String, String> map, Map<String, Object> param){
        Iterator<String> iterator = param.keySet().iterator();
        while (iterator.hasNext()){
            String key = iterator.next();
            if(CompatConstants.ABX_ITEMS.equals(key)){
                continue;
            }
            Object value = param.get(key);
            putMapByObject(map, VALUE_PARAM_PREFIX+key, value);
        }
    }
    public static void putMapByObject(Map<String, String> map, String key, Object value){
        if (value instanceof String) {
            map.put(key, (String) value);
        } else if (value instanceof Integer) {
            Integer converted = (Integer) value;
            map.put(key, String.valueOf(converted));
        } else if (value instanceof Long) {
            Long converted = (Long) value;
            map.put(key, String.valueOf(converted));
        } else if (value instanceof Double) {
            Double converted = (Double) value;
            map.put(key, String.valueOf(converted));
        } else if (value instanceof Boolean) {
            Boolean converted = (Boolean) value;
            map.put(key, getValueByBoolean(converted));
        }
    }

    public static void putItemsParam(Map<String, String> map, JSONObject jsonObject){
        Iterator<String> iter = jsonObject.keys();
        while(iter.hasNext()) {
            String key = iter.next();
            Object value = null;
            try {
                value = jsonObject.get(key);
            } catch (JSONException e) {
                continue;
            }
            putMapByObject(map, VALUE_PARAM_ITEMS_PREFIX+key, value);
        }
    }

    public static String getValueByBoolean(boolean value){
        if(value){
            return VALUE_TRUE;
        }else{
            return VALUE_FALSE;
        }
    }

    public static void putAttributionContextData(Map<String, String> map, GetAttributionDataResult attributionDataResult){
        map.put("attribution_result",attributionDataResult.getAttributionResult());
        switch (attributionDataResult.getResult()){
            case HAS_ATTRIBUTION:{
                NullableJSONObject jsonObject = null;
                try {
                    jsonObject = new NullableJSONObject(attributionDataResult.getAttributionData().toString());
                    Iterator<String> iter = jsonObject.keys();
                    while(iter.hasNext()) {
                        String key = iter.next();
                        String value = jsonObject.optString(key);
                        map.put(key, value);
                    }
                } catch (JSONException e) {
                    AbxLog.w(e, true);
                }
                break;
            }
            default:{
                break;
            }
        }
    }
}
