package io.adbrix.sdk.utils.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;

import java.io.IOException;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.utils.image.decode.DefaultImageDecoder;
import io.adbrix.sdk.utils.image.decode.ImageDecoder;
import io.adbrix.sdk.utils.image.download.ImageDownloader;

public class ImageLoader {
    //https://m2.material.io/design/platform-guidance/android-icons.html#specs
    public static final int SMALL_ICON_IMAGE_DEFAULT_WIDTH = 108;
    public static final int SMALL_ICON_IMAGE_DEFAULT_HEIGHT = 108;
    //https://documentation.onesignal.com/docs/customize-notification-icons
    public static final int LARGE_ICON_IMAGE_DEFAULT_WIDTH = 256;
    public static final int LARGE_ICON_IMAGE_DEFAULT_HEIGHT = 256;
    //dfinery console에서 600 x 300 ~ 1038 x 519 사이즈 허용
    public static final int BIG_PICTURE_IMAGE_DEFAULT_WIDTH = 1038;
    public static final int BIG_PICTURE_IMAGE_DEFAULT_HEIGHT = 519;
    private Context context;

    public ImageLoader(Context context) {
        this.context = context;
    }
    public Bitmap getImageFromDrawable(String fileName){
        return getImageFromDrawable(fileName, LARGE_ICON_IMAGE_DEFAULT_WIDTH, LARGE_ICON_IMAGE_DEFAULT_HEIGHT);
    }
    public Bitmap getImageFromDrawable(String fileName, int targetWidth, int targetHeight){
        String resName = fileName;
        if (fileName.contains(".")) {
            resName = fileName.substring(0, fileName.lastIndexOf("."));
            AbxLog.d("getImageResource file name: " + fileName + " --> " + resName, true);
        }
        int resourceId = context.getResources().getIdentifier(resName, ImageDownloader.Scheme.DRAWABLE.toString(), context.getPackageName());
        return this.getImageFromDrawable(resourceId, targetWidth, targetHeight);
    }
    public Bitmap getImageFromDrawable(int resourceId){
        return this.getImageFromDrawable(resourceId, LARGE_ICON_IMAGE_DEFAULT_WIDTH, LARGE_ICON_IMAGE_DEFAULT_HEIGHT);
    }
    public Bitmap getImageFromDrawable(int resourceId, int targetWidth, int targetHeight){
        ImageDecoder imageDecoder = new DefaultImageDecoder(this.context);
        Bitmap bitmap = null;
        try {
            final String imageUri = ImageDownloader.Scheme.DRAWABLE.wrap(String.valueOf(resourceId));
            bitmap = imageDecoder.decode(imageUri, targetWidth, targetHeight);
        } catch (IOException e) {
            AbxLog.e(e, true);
            return bitmap;
        }
        return bitmap;
    }

    public Bitmap getImageFromUrl(String url){
        return this.getImageFromUrl(url, BIG_PICTURE_IMAGE_DEFAULT_WIDTH, BIG_PICTURE_IMAGE_DEFAULT_HEIGHT);
    }
    public Bitmap getImageFromUrl(String url, int targetWidth, int targetHeight){
        return this.getImageFromUrl(url, targetWidth, targetHeight,0);
    }
    private Bitmap getImageFromUrl(String url, int targetWidth, int targetHeight, int attempt){
        ImageDecoder imageDecoder = new DefaultImageDecoder(this.context);
        Bitmap bitmap = null;
        try {
            bitmap = imageDecoder.decode(url, targetWidth, targetHeight);
        } catch (IOException e) {
            AbxLog.e(e, true);
            return bitmap;
        }
        if(attempt < 1){
            if(!isColoredImage(bitmap)){
                bitmap.recycle();
                bitmap = null;
                bitmap = this.getImageFromUrl(url, targetWidth, targetHeight,1);
            }
        }
        return bitmap;
    }
    private boolean isColoredImage(Bitmap bitmap){
        boolean result = true;
        if(bitmap == null){
            return result;
        }
        try {
            for (int x = 0; x< bitmap.getWidth(); x++) {
                for (int y = 0; y < bitmap.getHeight(); y++) {
                    int pixel = bitmap.getPixel(x,y);
                    int redValue = Color.red(pixel);
                    if(redValue != 255){
                        return result;
                    }
                    int blueValue = Color.blue(pixel);
                    if(blueValue != 255){
                        return result;
                    }
                    int greenValue = Color.green(pixel);
                    if(greenValue != 255){
                        return result;
                    }
                }
            }
        } catch (Exception e){
            AbxLog.e(e, true);
            return result;
        }
        result = false;
        return result;
    }
}
