/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.db.s3.AbstractS3Database;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.ImmutableFormMetadataRow;
import java.util.Date;
import java.util.function.Consumer;
import software.amazon.awssdk.services.s3.S3Client;

public class FormS3Database
extends AbstractS3Database<Form>
implements FormDatabase {
    public FormS3Database(S3Client s3Client, ObjectMapper objectMapper, String bucketName, String prefix) {
        super(s3Client, Form.class, objectMapper, bucketName, prefix);
    }

    public void findAllMetadata(String tenantId, Form.Metadata metadata, @NonNull Consumer<FormDatabase.FormMetadataRow> consumer) {
        this.forAllObjects(tenantId, object -> {
            String id = this.extractObjectName(object.key());
            consumer.accept((FormDatabase.FormMetadataRow)ImmutableFormMetadataRow.of((String)id, (Form.Metadata)ImmutableFormMetadata.builder().lastSaved(new Date(object.lastModified().toEpochMilli())).tenantId(tenantId).build()));
        });
    }

    @NonNull
    protected Form updateDocumentId(@NonNull Form form, String id) {
        return ImmutableForm.builder().from(form).id(id).build();
    }

    @NonNull
    protected Form updateDocumentRev(@NonNull Form form, String rev) {
        return ImmutableForm.builder().from(form).rev(rev).build();
    }

    @Override
    protected String tenantPrefix(String tenantId) {
        return "questionnaires/" + tenantId;
    }
}

