/*
 * Copyright © 2015 - 2021 ReSys (info@dialob.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.dialob.form.service.api;

import io.dialob.api.form.Form;
import org.immutables.value.Value;

import javax.annotation.Nonnull;
import java.util.function.Consumer;

public interface FormDatabase {

  @Nonnull
  Form findOne(@Nonnull String tenantId, @Nonnull String id, String rev);

  @Nonnull
  Form findOne(@Nonnull String tenantId, @Nonnull String id);

  boolean exists(@Nonnull String tenantId, @Nonnull String id);

  // flush whole cache, ensure that revisioned forms are flushed too
  boolean delete(String tenantId, @Nonnull String id);

  @Nonnull
  Form save(String tenantId, @Nonnull Form document);

  @Value.Immutable
  interface FormMetadataRow {
    @Value.Parameter
    @Nonnull
    String getId();

    @Value.Parameter
    @Nonnull
    Form.Metadata getValue();
  }

  void findAllMetadata(String tenantId, Form.Metadata metadata, @Nonnull Consumer<FormMetadataRow> consumer);
}
