/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.form.service.api.repository;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.ImmutableFormItem;
import io.dialob.form.service.api.repository.FormVisitor;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisitableForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisitableForm.class);
    private final Form form;

    private VisitableForm(@Nonnull Form form) {
        this.form = form;
    }

    public static VisitableForm makeVisitableForm(@Nonnull Form form) {
        return new VisitableForm(form);
    }

    public void accept(@Nonnull FormVisitor visitor) {
        visitor.start();
        visitor.visitForm(this.form);
        visitor.visitFormMetadata(this.form.getMetadata());
        Set<String> pages = this.findAllPages(this.form.getData());
        visitor.startFormItems().ifPresent(formItemVisitor -> {
            HashSet keys = new HashSet(this.form.getData().keySet());
            ArrayDeque<String> order = new ArrayDeque<String>();
            order.add("questionnaire");
            while (!order.isEmpty()) {
                String key = (String)order.remove();
                keys.remove(key);
                FormItem formItem = (FormItem)this.form.getData().get(key);
                if (formItem == null) {
                    LOGGER.warn("Could not find item: {}", (Object)key);
                    continue;
                }
                if (pages.contains(formItem.getId())) {
                    formItem = ImmutableFormItem.builder().from(formItem).type("page").build();
                }
                formItemVisitor.start();
                String type = formItem.getType();
                if (type != null) {
                    switch (type) {
                        case "questionnaire": {
                            formItemVisitor.visitQuestionnaireItem(formItem);
                            order.addAll(formItem.getItems());
                            break;
                        }
                        case "group": {
                            formItemVisitor.visitGroup(formItem);
                            order.addAll(formItem.getItems());
                            break;
                        }
                        case "rowgroup": {
                            formItemVisitor.visitRowGroup(formItem);
                            order.addAll(formItem.getItems());
                            break;
                        }
                        case "surveygroup": {
                            formItemVisitor.visitSurveyGroup(formItem);
                            order.addAll(formItem.getItems());
                            break;
                        }
                        case "page": {
                            formItemVisitor.visitPage(formItem);
                            order.addAll(formItem.getItems());
                            break;
                        }
                        case "note": {
                            formItemVisitor.visitNote(formItem);
                            break;
                        }
                        default: {
                            formItemVisitor.visitQuestion(formItem);
                        }
                    }
                    List validations = formItem.getValidations();
                    formItemVisitor.startValidations().ifPresent(validationVisitor -> {
                        validationVisitor.start();
                        validations.forEach(validationVisitor::visitValidation);
                        validationVisitor.end();
                    });
                    formItemVisitor.endValidations();
                }
                formItemVisitor.end();
            }
            if (!keys.isEmpty()) {
                LOGGER.warn("Items without hoisting group: {}", keys);
            }
        });
        visitor.endFormItems();
        visitor.startFormVariables().ifPresent(formVariableVisitor -> {
            formVariableVisitor.start();
            this.form.getVariables().forEach(formVariableVisitor::visitFormVariable);
            formVariableVisitor.end();
        });
        visitor.endFormVariables();
        visitor.startValueSets().ifPresent(valueSetVisitor -> {
            valueSetVisitor.start();
            this.form.getValueSets().forEach(valueSetVisitor::visitValueSet);
            valueSetVisitor.end();
        });
        visitor.endValueSets();
        visitor.end();
    }

    public Set<String> findAllPages(@Nonnull Map<String, FormItem> items) {
        HashSet<String> pages = new HashSet<String>();
        for (FormItem formItem : items.values()) {
            if (!"questionnaire".equals(formItem.getType())) continue;
            pages.addAll(formItem.getItems());
            break;
        }
        return pages;
    }
}

