/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.queue.redis;

import io.dialob.integration.api.NodeId;
import io.dialob.integration.api.event.DistributedEvent;
import jakarta.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;

public class DistributedEventBridge {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedEventBridge.class);
    private final MessageChannel messageChannel;
    private final ApplicationEventPublisher publisher;
    private final MessageBuilderFactory messageBuilderFactory;
    private final NodeId nodeId;

    public DistributedEventBridge(@Named(value="dialobEventsDistributionChannel") MessageChannel messageChannel, ApplicationEventPublisher publisher, MessageBuilderFactory messageBuilderFactory, NodeId nodeId) {
        this.messageChannel = messageChannel;
        this.publisher = publisher;
        this.messageBuilderFactory = messageBuilderFactory;
        this.nodeId = nodeId;
    }

    @EventListener
    public void onNodeStatus(DistributedEvent event) {
        if (this.isFromThisNode(event)) {
            LOGGER.debug("Publish distributed event: {}", (Object)event);
            try {
                this.messageChannel.send(this.messageBuilderFactory.withPayload((Object)event).build());
            }
            catch (MessageDeliveryException mde) {
                LOGGER.debug("Ups!");
                throw mde;
            }
        }
    }

    @ServiceActivator(inputChannel="dialobEventsDistributionChannel")
    public void receiveNodeStatus(DistributedEvent event) {
        LOGGER.debug("Received distributed event: {}", (Object)event);
        if (!this.isFromThisNode(event)) {
            this.publisher.publishEvent((Object)event);
        }
    }

    private boolean isFromThisNode(DistributedEvent event) {
        return this.nodeId.getId().equals(event.getSource());
    }
}

