/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.session;

import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.security.tenant.CurrentTenant;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuestionnaireSessionSaveService
implements QuestionnaireSessionSaveService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuestionnaireSessionSaveService.class);
    private final QuestionnaireDatabase questionnaireDatabase;
    private final CurrentTenant currentTenant;

    protected AbstractQuestionnaireSessionSaveService(@Nonnull QuestionnaireDatabase questionnaireDatabase, CurrentTenant currentTenant) {
        this.questionnaireDatabase = questionnaireDatabase;
        this.currentTenant = currentTenant;
    }

    @Override
    @Nonnull
    public QuestionnaireSession save(@Nonnull QuestionnaireSession questionnaireSession) {
        Questionnaire questionnaire = this.questionnaireDatabase.save(this.currentTenant.getId(), questionnaireSession.getQuestionnaire());
        return questionnaireSession.withIdAndRev(questionnaire.getId(), questionnaire.getRev());
    }
}

