/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.event;

import io.dialob.api.proto.Actions;
import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireActionsEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireEvent;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="QuestionnaireActionsEvent", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaireActionsEvent
implements QuestionnaireActionsEvent {
    private final Tenant tenant;
    private final String questionnaireId;
    private final Actions actions;

    private ImmutableQuestionnaireActionsEvent(Tenant tenant, String questionnaireId, Actions actions) {
        this.tenant = tenant;
        this.questionnaireId = questionnaireId;
        this.actions = actions;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    @Override
    public Actions getActions() {
        return this.actions;
    }

    public final ImmutableQuestionnaireActionsEvent withTenant(Tenant value) {
        if (this.tenant == value) {
            return this;
        }
        Tenant newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableQuestionnaireActionsEvent(newValue, this.questionnaireId, this.actions);
    }

    public final ImmutableQuestionnaireActionsEvent withQuestionnaireId(String value) {
        String newValue = Objects.requireNonNull(value, "questionnaireId");
        if (this.questionnaireId.equals(newValue)) {
            return this;
        }
        return new ImmutableQuestionnaireActionsEvent(this.tenant, newValue, this.actions);
    }

    public final ImmutableQuestionnaireActionsEvent withActions(Actions value) {
        if (this.actions == value) {
            return this;
        }
        Actions newValue = Objects.requireNonNull(value, "actions");
        return new ImmutableQuestionnaireActionsEvent(this.tenant, this.questionnaireId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaireActionsEvent && this.equalTo((ImmutableQuestionnaireActionsEvent)another);
    }

    private boolean equalTo(ImmutableQuestionnaireActionsEvent another) {
        return this.tenant.equals(another.tenant) && this.questionnaireId.equals(another.questionnaireId) && this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.questionnaireId.hashCode();
        h += (h << 5) + this.actions.hashCode();
        return h;
    }

    public String toString() {
        return "QuestionnaireActionsEvent{tenant=" + this.tenant + ", questionnaireId=" + this.questionnaireId + ", actions=" + this.actions + "}";
    }

    public static ImmutableQuestionnaireActionsEvent copyOf(QuestionnaireActionsEvent instance) {
        if (instance instanceof ImmutableQuestionnaireActionsEvent) {
            return (ImmutableQuestionnaireActionsEvent)instance;
        }
        return ImmutableQuestionnaireActionsEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuestionnaireActionsEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TENANT = 1L;
        private static final long INIT_BIT_QUESTIONNAIRE_ID = 2L;
        private static final long INIT_BIT_ACTIONS = 4L;
        private long initBits = 7L;
        @Nullable
        private Tenant tenant;
        @Nullable
        private String questionnaireId;
        @Nullable
        private Actions actions;

        private Builder() {
        }

        public final Builder from(QuestionnaireActionsEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QuestionnaireEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantScopedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QuestionnaireEvent instance;
            if (object instanceof QuestionnaireActionsEvent) {
                instance = (QuestionnaireActionsEvent)object;
                this.actions(instance.getActions());
            }
            if (object instanceof QuestionnaireEvent) {
                instance = (QuestionnaireEvent)object;
                this.questionnaireId(instance.getQuestionnaireId());
            }
            if (object instanceof TenantScopedEvent) {
                instance = (TenantScopedEvent)object;
                this.tenant(instance.getTenant());
            }
        }

        public final Builder tenant(Tenant tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder questionnaireId(String questionnaireId) {
            this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder actions(Actions actions) {
            this.actions = Objects.requireNonNull(actions, "actions");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableQuestionnaireActionsEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuestionnaireActionsEvent(this.tenant, this.questionnaireId, this.actions);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("questionnaireId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("actions");
            }
            return "Cannot build QuestionnaireActionsEvent, some of required attributes are not set " + attributes;
        }
    }
}

