/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.event;

import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireCreatedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireEvent;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="QuestionnaireCreatedEvent", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaireCreatedEvent
implements QuestionnaireCreatedEvent {
    private final Tenant tenant;
    private final String questionnaireId;

    private ImmutableQuestionnaireCreatedEvent(Tenant tenant, String questionnaireId) {
        this.tenant = tenant;
        this.questionnaireId = questionnaireId;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    public final ImmutableQuestionnaireCreatedEvent withTenant(Tenant value) {
        if (this.tenant == value) {
            return this;
        }
        Tenant newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableQuestionnaireCreatedEvent(newValue, this.questionnaireId);
    }

    public final ImmutableQuestionnaireCreatedEvent withQuestionnaireId(String value) {
        String newValue = Objects.requireNonNull(value, "questionnaireId");
        if (this.questionnaireId.equals(newValue)) {
            return this;
        }
        return new ImmutableQuestionnaireCreatedEvent(this.tenant, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaireCreatedEvent && this.equalTo((ImmutableQuestionnaireCreatedEvent)another);
    }

    private boolean equalTo(ImmutableQuestionnaireCreatedEvent another) {
        return this.tenant.equals(another.tenant) && this.questionnaireId.equals(another.questionnaireId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.questionnaireId.hashCode();
        return h;
    }

    public String toString() {
        return "QuestionnaireCreatedEvent{tenant=" + this.tenant + ", questionnaireId=" + this.questionnaireId + "}";
    }

    public static ImmutableQuestionnaireCreatedEvent copyOf(QuestionnaireCreatedEvent instance) {
        if (instance instanceof ImmutableQuestionnaireCreatedEvent) {
            return (ImmutableQuestionnaireCreatedEvent)instance;
        }
        return ImmutableQuestionnaireCreatedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuestionnaireCreatedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TENANT = 1L;
        private static final long INIT_BIT_QUESTIONNAIRE_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Tenant tenant;
        @Nullable
        private String questionnaireId;

        private Builder() {
        }

        public final Builder from(QuestionnaireEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantScopedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QuestionnaireCreatedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QuestionnaireEvent instance;
            if (object instanceof QuestionnaireEvent) {
                instance = (QuestionnaireEvent)object;
                this.questionnaireId(instance.getQuestionnaireId());
            }
            if (object instanceof TenantScopedEvent) {
                instance = (TenantScopedEvent)object;
                this.tenant(instance.getTenant());
            }
        }

        public final Builder tenant(Tenant tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder questionnaireId(String questionnaireId) {
            this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableQuestionnaireCreatedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuestionnaireCreatedEvent(this.tenant, this.questionnaireId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("questionnaireId");
            }
            return "Cannot build QuestionnaireCreatedEvent, some of required attributes are not set " + attributes;
        }
    }
}

