/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.event;

import io.dialob.api.proto.Actions;
import io.dialob.integration.api.event.Event;
import io.dialob.integration.api.event.EventPublisher;
import io.dialob.questionnaire.service.api.event.ImmutableQuestionnaireActionsEvent;
import io.dialob.questionnaire.service.api.event.ImmutableQuestionnaireClientConnectedEvent;
import io.dialob.questionnaire.service.api.event.ImmutableQuestionnaireClientDisconnectedEvent;
import io.dialob.questionnaire.service.api.event.ImmutableQuestionnaireCompletedEvent;
import io.dialob.questionnaire.service.api.event.ImmutableQuestionnaireCreatedEvent;
import io.dialob.questionnaire.service.api.event.ImmutableQuestionnaireOpenedEvent;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.security.tenant.ResysSecurityConstants;
import io.dialob.security.tenant.Tenant;
import java.net.InetAddress;
import java.util.Optional;
import javax.annotation.Nonnull;

public class QuestionnaireEventPublisher {
    private final EventPublisher applicationEventPublisher;
    private final CurrentTenant currentTenant;

    private Tenant getTenant() {
        Tenant tenant = this.currentTenant.get();
        if (tenant == null) {
            return ResysSecurityConstants.DEFAULT_TENANT;
        }
        return tenant;
    }

    private Tenant getTenant(String tenantId) {
        if (tenantId != null) {
            return ImmutableTenant.of((String)tenantId, Optional.empty());
        }
        return ResysSecurityConstants.DEFAULT_TENANT;
    }

    public QuestionnaireEventPublisher(@Nonnull EventPublisher applicationEventPublisher, CurrentTenant currentTenant) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.currentTenant = currentTenant;
    }

    public void opened(@Nonnull String questionnaireId) {
        this.applicationEventPublisher.publish((Event)ImmutableQuestionnaireOpenedEvent.builder().tenant(this.getTenant()).questionnaireId(questionnaireId).build());
    }

    public void created(@Nonnull String questionnaireId) {
        this.applicationEventPublisher.publish((Event)ImmutableQuestionnaireCreatedEvent.builder().tenant(this.getTenant()).questionnaireId(questionnaireId).build());
    }

    public void completed(String tenantId, @Nonnull String questionnaireId) {
        this.applicationEventPublisher.publish((Event)ImmutableQuestionnaireCompletedEvent.builder().tenant(this.getTenant(tenantId)).questionnaireId(questionnaireId).build());
    }

    public void actions(@Nonnull String questionnaireId, @Nonnull Actions actions) {
        this.applicationEventPublisher.publish((Event)ImmutableQuestionnaireActionsEvent.builder().tenant(this.getTenant()).questionnaireId(questionnaireId).actions(actions).build());
    }

    public void clientConnected(@Nonnull String questionnaireId, InetAddress client) {
        this.applicationEventPublisher.publish((Event)ImmutableQuestionnaireClientConnectedEvent.builder().tenant(this.getTenant()).questionnaireId(questionnaireId).client(client).build());
    }

    public void clientDisconnected(@Nonnull String questionnaireId, InetAddress client, int closeStatus) {
        this.applicationEventPublisher.publish((Event)ImmutableQuestionnaireClientDisconnectedEvent.builder().tenant(this.getTenant()).questionnaireId(questionnaireId).client(client).closeStatus(closeStatus).build());
    }
}

