/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import com.google.common.collect.Maps;
import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.api.RuleExpressionCompilerError;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.api.VariableNotDefinedException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ExpressionTest {
    @Test
    public void testRenameId() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)Expression.createExpression((String)"a").renameId("a", "b").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + r", (Object)Expression.createExpression((String)"1 + a").renameId("a", "r").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + abc - 5", (Object)Expression.createExpression((String)"1 + f - 5").renameId("f", "abc").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + abc - abc", (Object)Expression.createExpression((String)"1 + f - f").renameId("f", "abc").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + f - f", (Object)Expression.createExpression((String)"1 + abc - abc").renameId("abc", "f").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + a - ab >= abc", (Object)Expression.createExpression((String)"1 + a - f >= abc").renameId("f", "ab").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + a - f >= abc", (Object)Expression.createExpression((String)"1 + a - ab >= abc").renameId("ab", "f").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + a - f >=    abc ", (Object)Expression.createExpression((String)"1 + a - ab >=    abc ").renameId("ab", "f").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 + a - \"ab\" >=    abc ", (Object)Expression.createExpression((String)"1 + a - \"ab\" >=    abc ").renameId("ab", "f").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc + ab + abc + ab +abc", (Object)Expression.createExpression((String)"a + ab + abc + ab +a").renameId("a", "abc").toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a + ab + a + ab +a", (Object)Expression.createExpression((String)"a + ab + abc + ab +a").renameId("abc", "a").toString());
    }

    @Test
    public void testIdCollecting() {
        Assertions.assertThat((Collection)Expression.createExpression((String)"a").getAllIds()).containsExactly((Object[])new String[]{"a"});
        Assertions.assertThat((Collection)Expression.createExpression((String)"1 + r").getAllIds()).containsExactly((Object[])new String[]{"r"});
        Assertions.assertThat((Collection)Expression.createExpression((String)"a + b").getAllIds()).containsExactly((Object[])new String[]{"a", "b"});
        Assertions.assertThat((Collection)Expression.createExpression((String)"a + ab + a + ab +a").getAllIds()).containsExactly((Object[])new String[]{"a", "ab"});
    }

    @Test
    public void shouldEmptyStringGeneratesEmptyAst() {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expression.getErrors().size());
        org.junit.jupiter.api.Assertions.assertNull((Object)expression.getAst());
    }

    @Test
    public void shouldBlankInputGeneratesEmptyAst() {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"   ");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expression.getErrors().size());
        org.junit.jupiter.api.Assertions.assertNull((Object)expression.getAst());
    }

    @Test
    public void shouldReportSyntaxError() {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"a a");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expression.getErrors().size());
        Assertions.assertThat((List)expression.getErrors()).extracting(RuleExpressionCompilerError::getErrorCode).containsOnly((Object[])new String[]{"SYNTAX_ERROR"});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").containsOnly(new Object[]{2});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").containsOnly(new Object[]{2});
        org.junit.jupiter.api.Assertions.assertNull((Object)expression.getAst());
    }

    @Test
    public void cannotSumBooleanAndInteger() {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"1+true");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expression.getErrors().size());
        Assertions.assertThat((List)expression.getErrors()).extracting(RuleExpressionCompilerError::getErrorCode).containsOnly((Object[])new String[]{"CANNOT_ADD_TYPES"});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").containsOnly(new Object[]{0});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").containsOnly(new Object[]{5});
    }

    @Test
    public void cannotSumDateAndInteger() throws VariableNotDefinedException {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Mockito.when((Object)variableFinder.typeOf("date")).thenReturn((Object)ValueType.DATE);
        Mockito.when((Object)variableFinder.mapAlias((String)ArgumentMatchers.any())).then(AdditionalAnswers.returnsFirstArg());
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"date + 1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expression.getErrors().size());
        Assertions.assertThat((List)expression.getErrors()).extracting(RuleExpressionCompilerError::getErrorCode).containsOnly((Object[])new String[]{"CANNOT_ADD_TYPES"});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").containsOnly(new Object[]{0});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").containsOnly(new Object[]{7});
    }

    @Test
    public void cannotComparePeriodAndInteger() {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"1 day > 1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expression.getErrors().size());
        Assertions.assertThat((List)expression.getErrors()).extracting(RuleExpressionCompilerError::getErrorCode).containsOnly((Object[])new String[]{"NO_ORDER_RELATION_BETWEEN_TYPES"});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").containsOnly(new Object[]{0});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").containsOnly(new Object[]{8});
    }

    @Test
    public void cannotEqualPeriodAndInteger() {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"1 day = 1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expression.getErrors().size());
        Assertions.assertThat((List)expression.getErrors()).extracting(RuleExpressionCompilerError::getErrorCode).containsOnly((Object[])new String[]{"NO_EQUALITY_RELATION_BETWEEN_TYPES"});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").containsOnly(new Object[]{0});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").containsOnly(new Object[]{8});
    }

    @Test
    public void brokenStringShouldNotKillParser() {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"a = 'x ");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)expression.getErrors().size());
        Assertions.assertThat((List)expression.getErrors()).extracting(RuleExpressionCompilerError::getErrorCode).containsOnly((Object[])new String[]{"SYNTAX_ERROR"});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").containsExactly(new Object[]{4, 7});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").containsExactly(new Object[]{4, 7});
        org.junit.jupiter.api.Assertions.assertNull((Object)expression.getAst());
    }

    @Test
    public void brokenExpectStringForIsBlank() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Mockito.when((Object)variableFinder.typeOf("a")).thenReturn((Object)ValueType.DATE);
        Mockito.when((Object)variableFinder.mapAlias((String)ArgumentMatchers.any())).then(AdditionalAnswers.returnsFirstArg());
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"a is blank");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expression.getErrors().size());
        Assertions.assertThat((List)expression.getErrors()).extracting(RuleExpressionCompilerError::getErrorCode).containsOnly((Object[])new String[]{"STRING_VALUE_EXPECTED"});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").containsExactly(new Object[]{0});
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").containsExactly(new Object[]{0});
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(isBlank a)", (Object)expression.getAst().toString());
    }

    @Test
    public void isNullOperator() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Mockito.when((Object)variableFinder.typeOf("a")).thenReturn((Object)ValueType.DATE);
        Mockito.when((Object)variableFinder.mapAlias((String)ArgumentMatchers.any())).then(AdditionalAnswers.returnsFirstArg());
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"a is null");
        Assertions.assertThat((List)expression.getErrors()).extracting("span.startIndex").isEmpty();
        Assertions.assertThat((List)expression.getErrors()).extracting("span.stopIndex").isEmpty();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(isNull a)", (Object)expression.getAst().toString());
    }
}

