/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.ExpressionWriterVisitor;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.NodeBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionWriterVisitorTest {
    @Test
    public void test() {
        this.assertAstDump("1+2+4 > 9", "1 + 2 + 4 > 9");
        this.assertAstDump("1*(hn+4) > 9", "1 * (hn + 4) > 9");
        this.assertAstDump("1/(hn+4) > 9", "1 / (hn + 4) > 9");
        this.assertAstDump("1/(hn+4) > 9 or 9-0 <= 9*3+1", "1 / (hn + 4) > 9 or 9 - 0 <= 9 * 3 + 1");
        this.assertAstDump("true and true", "true and true");
        this.assertAstDump("true or true", "true or true");
        this.assertAstDump("true or true and false", "true or true and false");
        this.assertAstDump("(true or true) and false", "(true or true) and false");
        this.assertAstDump("(not true or true) and false", "(not true or true) and false");
        this.assertAstDump("not (true or true) and false", "not (true or true) and false");
        this.assertAstDump("1+2 = 3 and false = true", "(1 + 2) = 3 and false = true");
        this.assertAstDump("4 = 1+2 or false = false", "4 = (1 + 2) or false = false");
        this.assertAstDump("func(1,4)", "func ( 1, 4 )");
        this.assertAstDump("func(1,x,6)", "func ( 1, x, 6 )");
        this.assertAstDump("func(1,x-2,6)", "func ( 1, x - 2, 6 )");
        this.assertAstDump("func(1,(x-2)*8,6)", "func ( 1, (x - 2) * 8, 6 )");
        this.assertAstDump("-1+2+3-3+2+1 = -8*9+-2+6", "-1 + 2 + 3 - 3 + 2 + 1 = -8 * 9 + -2 + 6");
        this.assertAstDump("-(9+6)", "-(9 + 6)");
        this.assertAstDump("-(9*6)", "-(9*6)");
        this.assertAstDump("opt in opt1", "opt in ('opt1')");
        this.assertAstDump("opt notIn opt1", "opt not in ('opt1')");
    }

    private void assertAstDump(String expected, String original) {
        ExpressionWriterVisitor visitor = new ExpressionWriterVisitor();
        Expression expression = Expression.createExpression((String)original);
        Assertions.assertFalse((boolean)expression.hasErrors());
        NodeBase ast = expression.getAst();
        System.out.println(ast);
        ast.accept((ASTVisitor)visitor);
        Assertions.assertEquals((Object)expected, (Object)visitor.toString());
    }
}

