/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import io.dialob.rule.parser.node.ParseTestBase;
import org.junit.jupiter.api.Test;

public class FFRuleParserTest
extends ParseTestBase {
    @Test
    public void test() throws Exception {
        this.assertExpressionEquals("", "");
        this.assertExpressionEquals("// comment", "");
        this.assertExpressionEquals("1", "1");
        this.assertExpressionEquals("a+1*u/(5+9) = 2 and 0 = 0 ", "(and (= (+ a (/ (* 1 u) (+ 5 9))) 2) (= 0 0))");
        this.assertExpressionEquals("a-1*u/(5-9) = 2 and 0 = 0 ", "(and (= (- a (/ (* 1 u) (- 5 9))) 2) (= 0 0))");
        this.assertExpressionEquals("not a-1*u/(5-9) = 2 // This is comment \n and 0 = 0 ", "(and (not (= (- a (/ (* 1 u) (- 5 9))) 2)) (= 0 0))");
        this.assertExpressionEquals("answer < today // This is comment", "(< answer today)");
        this.assertExpressionEquals("answer > today", "(> answer today)");
        this.assertExpressionEquals("answer <= today", "(<= answer today)");
        this.assertExpressionEquals("answer >= today", "(>= answer today)");
        this.assertExpressionEquals("answer >= today - 1 day", "(>= answer (- today \"1 day\"))");
        this.assertExpressionEquals("answer >= today + 12 years", "(>= answer (+ today \"12 years\"))");
        this.assertExpressionEquals("age(answer, today) < 18", "(< (age answer today) 18)");
        this.assertExpressionEquals("age(answer) < 18", "(< (age answer) 18)");
        this.assertExpressionEquals("today - answer < 18 years", "(< (- today answer) \"18 years\")");
        this.assertExpressionEquals("answer > startDate", "(> answer startDate)");
        this.assertExpressionEquals("1 - 2 - 3 = -4", "(= (- (- 1 2) 3) (neg 4))");
        this.assertExpressionEquals("-1 - 2 - 3 = -6", "(= (- (- (neg 1) 2) 3) (neg 6))");
        this.assertExpressionEquals("q1 is answered", "(isAnswered q1)");
        this.assertExpressionEquals("q1 is not answered", "(isNotAnswered q1)");
        this.assertExpressionEquals("not q1 is not answered", "(not (isNotAnswered q1))");
        this.assertExpressionEquals("not q1 is not answered and q2 is answered", "(and (not (isNotAnswered q1)) (isAnswered q2))");
        this.assertExpressionEquals("not q1 is not answered and q2 is answered or q3 is answered", "(or (and (not (isNotAnswered q1)) (isAnswered q2)) (isAnswered q3))");
        this.assertExpressionEquals("not q1 is not answered", "(not (isNotAnswered q1))");
        this.assertExpressionEquals("answer in (1,2,3)", "(in answer 1 2 3)");
        this.assertExpressionEquals("answer not in (1,2,3)", "(notIn answer 1 2 3)");
        this.assertExpressionEquals("answer in listQuestion", "(in answer listQuestion)");
        this.assertExpressionEquals("answer not in listQuestion", "(notIn answer listQuestion)");
        this.assertExpressionEquals("question is valid", "(isValid question)");
        this.assertExpressionEquals("question is not valid", "(isNotValid question)");
        this.assertExpressionEquals("personWeight/(personHeight*personHeight)", "(/ personWeight (* personHeight personHeight))");
        this.assertExpressionEquals("sum of wage", "(sumOf wage)");
        this.assertExpressionEquals("sum of (wage + 1)", "(sumOf (+ wage 1))");
        this.assertExpressionEquals("all of question is answered", "(allOf (isAnswered question))");
        this.assertExpressionEquals("1 + sum of wage", "(+ 1 (sumOf wage))");
        this.assertExpressionEquals("sum of wage + 1", "(+ (sumOf wage) 1)");
        this.assertExpressionEquals("all of (wage > 0)", "(allOf (> wage 0))");
        this.assertExpressionEquals("sum of wage > 0", "(> (sumOf wage) 0)");
        this.assertExpressionEquals("sumOf(wage) + 1", "(+ (sumOf wage) 1)");
        this.assertExpressionEquals("sumOf(wage + 1)", "(sumOf (+ wage 1))");
        this.assertExpressionEquals("(all of question is answered) and q2 is not answered", "(and (allOf (isAnswered question)) (isNotAnswered q2))");
        this.assertExpressionEquals("all of question is answered and q2 is not answered", "(and (allOf (isAnswered question)) (isNotAnswered q2))");
        this.assertExpressionEquals("q2 is not answered and all of question is answered", "(and (isNotAnswered q2) (allOf (isAnswered question)))");
        this.assertExpressionEquals("q2 is not answered or all of question is answered ", "(or (isNotAnswered q2) (allOf (isAnswered question)))");
        this.assertExpressionEquals("all of question is answered or q2 is not answered", "(or (allOf (isAnswered question)) (isNotAnswered q2))");
        this.assertExpressionEquals("(sum of wage) + 1", "(+ (sumOf wage) 1)");
    }
}

