/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.analyze;

import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.analyze.NotExpressionVisitor;
import io.dialob.rule.parser.node.ASTVisitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NotExpressionVisitorTest {
    @Test
    public void test() {
        String expr = "true";
        String expect = "false";
        this.assertExpressionNot("(notMatches a \".*\")", "a matches '.*'");
        this.assertExpressionNot("false", "true");
        this.assertExpressionNot("true", "false");
        this.assertExpressionNot("true", "not true");
        this.assertExpressionNot("(or false false)", "true and true");
        this.assertExpressionNot("(and (!= a 0) (= b 1))", "a = 0 or b != 1");
        this.assertExpressionNot("(or (<= a 0) (< b 1))", "a > 0 and  b >= 1");
        this.assertExpressionNot("(or (<= a 0) (and true false))", "a > 0 and not (true and false)");
        this.assertExpressionNot("(or (<= a 0) (not (or false true)))", "a > 0 and not not (false or true)");
        this.assertExpressionNot("(isNotAnswered a)", "a is answered");
        this.assertExpressionNot("(isAnswered a)", "a is not answered");
        this.assertExpressionNot("(matches a \".*\")", "a not matches '.*'");
        this.assertExpressionNot("(notIn a 1 2 3)", "a in (1,2,3)");
        this.assertExpressionNot("(in a 1 2 3)", "a not in (1,2,3)");
    }

    protected void assertExpressionNot(String expect, String expr) {
        Expression expression = Expression.createExpression((String)expr);
        expression.accept((ASTVisitor)new NotExpressionVisitor());
        Assertions.assertEquals((Object)expect, (Object)expression.getAst().toString());
    }
}

